package com.kdgcsoft.jt.xzzf.dubbo.zbgl.zfcl.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.excel.jxls.ExcelRowInfo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.zfcl.entity.ClsyxxVo;

import java.util.List;
import java.util.Map;

/****
 * @className ClsyxxService
 * @author hufanghua
 * @description 车辆审验信息Service接口层接口
 * @version 1.0
 * @date 2020-06-10 15:03
 */
public interface ClsyxxService {
    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @return
     */
    public Page<ClsyxxVo> page(Page<ClsyxxVo> page, ClsyxxVo entity,String orgId);

    /*****
     * 保存或修改车辆审验信息数据
     * @param entity 实体类
     * @param user 当前登录用户
     * @param isCreate 是否创建
     */
    public void saveOrUpdate(ClsyxxVo entity, SysUser user, boolean isCreate);

    /*****
     * 获取车辆审验信息信息
     * @param id 主键ID
     * @return
     */
    public ClsyxxVo getEntityInfoById(String id);

    /*****
     * 删除车辆审验信息信息
     * @param ids 主键Id集合
     */
    public void deleteDataByIds(String ids, SysUser user);

    /*****
     * 导入Excel
     * @param dataList
     * @param user
     * @return
     */
    public ExcelRowInfo importExcel(List<Map<String, Object>> dataList, SysUser user);
}
