package com.kdgcsoft.jt.xzzf.dubbo.zbgl.zfcl.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.excel.jxls.ExcelRowInfo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.zfcl.entity.ClsyqkdjVo;

import java.util.List;
import java.util.Map;

/****
 * @className ClsyqkdjService
 * @author hufanghua
 * @description 车辆使用情况登记Service接口层接口
 * @version 1.0
 * @date 2020-06-04 17:03
 */
public interface ClsyqkdjService {
    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @return
     */
    public Page<ClsyqkdjVo> page(Page<ClsyqkdjVo> page, ClsyqkdjVo entity,String orgId);

    /*****
     * 保存或修改车辆月度使用情况登记数据
     * @param entity 实体类
     * @param user 当前登录用户
     * @param isCreate 是否创建
     */
    public void saveOrUpdate(ClsyqkdjVo entity, SysUser user, boolean isCreate);

    /*****
     * 获取车辆月度使用情况登记
     * @param id 主键ID
     * @return
     */
    public ClsyqkdjVo getEntityInfoById(String id);

    /*****
     * 删除车辆月度使用情况登记信息
     * @param ids 主键Id集合
     */
    public void deleteDataByIds(String ids, SysUser user);

    /*****
     * 根据车牌号码查询该车辆在上一次的行驶里程
     * @param cphm 车牌号码
     */
    public ClsyqkdjVo queryDqlcByCphm(String cphm);

    /*****
     * 导入Excel
     * @param dataList
     * @param user
     * @return
     */
    public ExcelRowInfo importExcel(List<Map<String, Object>> dataList, SysUser user);
}
