package com.kdgcsoft.jt.xzzf.dubbo.zbgl.zfcl.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.ComboboxVo;
import com.kdgcsoft.jt.xzzf.common.excel.jxls.ExcelRowInfo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.zfcl.entity.CllxVo;

import java.util.List;
import java.util.Map;

/****
 * @className CllxService
 * @author hufanghua
 * @description 车辆类型Service接口层接口
 * @version 1.0
 * @date 2020-05-29 15:03
 */
public interface CllxService {
    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @return
     */
    public Page<CllxVo> page(Page<CllxVo> page, CllxVo entity);

    /*****
     * 保存或修改车辆类型数据
     * @param entity 实体类
     * @param user 当前登录用户
     * @param isCreate 是否创建
     */
    public void saveOrUpdate(CllxVo entity, SysUser user, boolean isCreate);

    /*****
     * 获取车辆类型信息
     * @param id 主键ID
     * @return
     */
    public CllxVo getEntityInfoById(String id);

    /*****
     * 删除车辆类型信息
     * @param ids 主键Id集合
     */
    public void deleteDataByIds(String ids, SysUser user);

    /*****
     * 车辆类型下拉框数据
     * @param filter 关键字过滤
     * @return
     */
    public List<ComboboxVo> queryEntityCombobox(String filter);

    /*****
     * 导入Excel
     * @param dataList
     * @param user
     * @return
     */
    public ExcelRowInfo importExcel(List<Map<String, Object>> dataList, SysUser user);
//
//    /******
//     * 导入Excel
//     * @param dataList
//     * @param user
//     */
//    public Result importExcel(List<Map<String, Object>> dataList, SysUser user);
}
