package com.kdgcsoft.jt.xzzf.dubbo.zbgl.zfcl.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ZfclztxxVo
 * @author hufanghua
 * @description 执法车辆状态信息实体
 * @version 1.0
 * @date 2020-06-02 09:59
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZBGL + "ZFZBGL_ZFCL_ZFCLZTXX")
public class ZfclztxxVo extends BaseEntity<String> {

    /***
     * 执法车辆状态ID
     */
    @TableId("ZFCLZTID")
    private String zfclztid;

    /******
     * 执法车辆ID
     */
    private String zfclid;

    /******
     * 车辆状态编号
     */
    private String clztbh;

    /******
     * 执法车辆状态
     */
    private String zfclzt;

    /******
     * 记录日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date jlrq;

    /******
     * 记录人
     */
    private String jlr;

    /******
     * 备注
     */
    private String bz;

    @Override
    public String getId() {
        return this.zfclztid;
    }

    @Override
    public void setId(String id) {
        this.zfclztid = id;
    }
}
