package com.kdgcsoft.jt.xzzf.dubbo.zbgl.zfcl.entity;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.constant.SystemConstants;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import com.kdgcsoft.jt.xzzf.common.util.BeanUtils;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ZfclxxVo
 * @author hufanghua
 * @description 执法车辆信息实体类
 * @version 1.0
 * @date 2020-05-22 10:18
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZBGL + "ZFZBGL_ZFCL_ZFCLXX")
public class ZfclxxVo extends BaseEntity<String> {
    /******
     * 执法车辆id
     */
    @TableId("ZFCLID")
    private String zfclid;

    /******
     * 执法车辆状态id
     */
    @TableField(exist = false)
    private String zfclztid;

    /******
     * 警灯使用证信息ID
     */
    private String jdsyzxxid;

    /******
     * 车辆类型编号
     */
    private String cllxbh;

    /******
     * 车辆类型
     */
    private String cllx;

    /******
     * 车型
     */
    private String cx;

    /******
     * 车型文本值
     */
    @TableField(exist = false)
    private String cxText;

    /******
     * 车辆单位
     */
    private String cldw;

    /******
     * 车辆单位id
     */
    private String cldwid;

    /******
     * 车牌号码
     */
    private String cphm;

    /******
     * 厂牌型号
     */
    private String cpxh;

    /******
     * 管理负责人
     */
    private String glfzr;

    /******
     * 管理负责人id
     */
    private String glfzrid;

    /******
     * 发动机号
     */
    private String fdjh;

    /******
     * 车辆识别代号
     */
    private String clsbdh;

    /******
     * 初始公里数
     */
    private String csgls;

    /******
     * 车架号码
     */
    private String cjhm;

    /******
     * 车辆是否带监控
     */
    private String clsfdjk;

    /******
     * 车辆是否带监控文本值
     */
    @TableField(exist = false)
    private String clsfdjkText;

    /******
     * 车辆年审到期日
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date clnsdqr;

    /******
     * 登记人
     */
    private String djr;

    /******
     * 登记日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date djrq;

    /******
     * 购置日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date gzrq;

    /******
     * 备注
     */
    private String bz;

    /******
     * 车辆状态编号
     */
    @TableField(exist = false)
    private String clztbh;

    /******
     * 车辆状态
     */
    @TableField(exist = false)
    private String zfclzt;

    /******
     * 车辆状态备注
     */
    @TableField(exist = false)
    private String clztbz;

    /***
     * 年审开始时间
     */
    @TableField(exist = false)
    private String clnsStartFilterTime;

    /***
     * 年审截止时间
     */
    @TableField(exist = false)
    private String clnsEndFilterTime;

    /******
     * 车辆年审到期日过滤条件
     */
    @TableField(exist = false)
    private String[] nsdqrFilterTime;

    /******
     * 管理负责人联系电话
     */
    @TableField(exist = false)
    private String lxdh;

    /******
     * 管理负责人组织机构
     */
    @TableField(exist = false)
    private String glfzrdw;

    /******
     * 示警灯使用证编号
     */
    @TableField(exist = false)
    private String sjdsyzbh;

    /******
     * 管理负责人组织机构id
     */
    @TableField(exist = false)
    private String glfzrdwid;

    /******
     * 统计数量
     */
    @TableField(exist = false)
    private String count;

    /******
     * 上传附件详情
     */
    @TableField(exist = false)
    private String attachmentDetail;

    /******
     * 库存状态
     */
    @TableField(exist = false)
    private String kczt;

    /******
     * 调入状态
     */
    @TableField(exist = false)
    private String drzt;

    /******
     * 即将到期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    @TableField(exist = false)
    private Date jjdq;

    /**
     * 事件与执法车辆位置距离 add 2020-08-17 yangqianhai
     */
    @TableField(exist = false)
    private String sjAndZfclDistance;

    /**
     * 执法车辆监控视频设备puid
     */
    @TableField(exist = false)
    private String puid;

    @Override
    public String getId() {
        return this.zfclid;
    }

    @Override
    public void setId(String id) {
        this.zfclid = id;
    }

    public DateTime getClnsStartTime() {
        if (BeanUtils.isNotEmpty(this.clnsStartFilterTime)) {
            return DateUtil.parse(this.clnsStartFilterTime + SystemConstants.START_TIME_SPLICING);
        } else if (BeanUtils.isNotEmpty(this.nsdqrFilterTime)) {
            if (BeanUtils.isNotEmpty(this.nsdqrFilterTime[0])) {
                return DateUtil.parse(this.nsdqrFilterTime[0] + SystemConstants.START_TIME_SPLICING);
            } else {
                return DateUtil.parse(this.nsdqrFilterTime + SystemConstants.START_TIME_SPLICING);
            }
        } else {
            return null;
        }
    }

    public DateTime getClnsEndTime() {
        if (BeanUtils.isNotEmpty(this.clnsEndFilterTime)) {
            return DateUtil.parse(this.clnsEndFilterTime + SystemConstants.END_TIME_SPLICING);
        } else if (BeanUtils.isNotEmpty(this.nsdqrFilterTime)) {
            if (BeanUtils.isNotEmpty(this.nsdqrFilterTime[this.nsdqrFilterTime.length - 1])) {
                return DateUtil.parse(this.nsdqrFilterTime[this.nsdqrFilterTime.length - 1] + SystemConstants.END_TIME_SPLICING);
            } else {
                return DateUtil.parse(this.nsdqrFilterTime + SystemConstants.END_TIME_SPLICING);
            }
        } else {
            return null;
        }
    }
}
