package com.kdgcsoft.jt.xzzf.dubbo.zbgl.zfcl.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className SyzztxxVo
 * @author hufanghua
 * @description 使用证状态信息实体
 * @version 1.0
 * @date 2020-06-08 09:59
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZBGL + "ZFZBGL_ZFCL_SYZZTXX")
public class SyzztxxVo extends BaseEntity<String> {

    /***
     * 使用证状态ID
     */
    @TableId("SYZZTID")
    private String syzztid;

    /******
     * 警灯使用证信息ID
     */
    private String jdsyzxxid;

    /******
     * 使用证状态编号
     */
    private String syzztbh;

    /******
     * 使用证状态
     */
    private String syzzt;

    /******
     * 记录日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date jlrq;

    /******
     * 记录人
     */
    private String jlr;

    /******
     * 备注
     */
    private String bz;

    @Override
    public String getId() {
        return this.syzztid;
    }

    @Override
    public void setId(String id) {
        this.syzztid = id;
    }
}
