package com.kdgcsoft.jt.xzzf.dubbo.zbgl.zfcl.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className SjdsyzxxVo
 * @author hufanghua
 * @description 示警灯使用证信息实体类
 * @version 1.0
 * @date 2020-06-05 10:18
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZBGL + "ZFZBGL_ZFCL_SJDSYZXX")
public class SjdsyzxxVo extends BaseEntity<String> {
    /******
     * 警灯使用证信息ID
     */
    @TableId("JDSYZXXID")
    private String jdsyzxxid;

    /******
     * 使用证状态主键id
     */
    @TableField(exist = false)
    private String syzztid;

    /******
     * 示警灯使用证编号
     */
    private String sjdsyzbh;

    /******
     * 车牌号码
     */
    private String cphm;

    /******
     * 使用单位
     */
    private String sydw;

    /******
     * 使用单位id
     */
    private String sydwid;

    /******
     * 厂牌型号
     */
    private String cpxh;

    /******
     * 是否已经规范标识和示警灯
     */
    private String sfyjgfbshsjd;

    /******
     * 是否已经规范标识和示警灯文本
     */
    @TableField(exist = false)
    private String sfyjgfbshsjdText;

    /******
     * 执法类别
     */
    private String zflb;

    /******
     * 发动机号
     */
    private String fdjh;

    /******
     * 车辆识别代号
     */
    private String clsbdh;

    /******
     * 示警灯型号
     */
    private String sjdxh;

    /******
     * 发证日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date fzrq;

    /******
     * 有效期至
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date yxqz;

    /******
     * 发证机关
     */
    private String fzjg;

    /******
     * 登记人
     */
    private String djr;

    /******
     * 登记日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date djrq;

    /******
     * 签发人
     */
    private String qfr;

    /******
     * 经办人
     */
    private String jbr;

    /******
     * 签发人id
     */
    private String qfrid;

    /******
     * 经办人id
     */
    private String jbrid;

    /******
     * 备注
     */
    private String bz;

    /******
     * 车型
     */
    private String cx;

    /******
     * 车型
     */
    @TableField(exist = false)
    private String cxText;

    /******
     * 使用证状态bh
     */
    @TableField(exist = false)
    private String syzztbh;

    /******
     * 使用证状态
     */
    @TableField(exist = false)
    private String syzzt;

    /******
     * 使用证备注
     */
    @TableField(exist = false)
    private String syzbz;

    /******
     * 发证日期过滤条件
     */
    @TableField(exist = false)
    private String[] syzFilterTime;

    /******
     * 上传附件详情
     */
    @TableField(exist = false)
    private String attachmentDetail;

    /******
     * 数量统计
     */
    @TableField(exist = false)
    private String count;

    /******
     * 有效期至
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    @TableField(exist = false)
    private Date jjdq;

    @Override
    public String getId() {
        return this.jdsyzxxid;
    }

    @Override
    public void setId(String id) {
        this.jdsyzxxid = id;
    }
}
