package com.kdgcsoft.jt.xzzf.dubbo.zbgl.zfcl.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className PfjghxxbVo
 * @author hufanghua
 * @description 执法车辆配发及归还信息实体
 * @version 1.0
 * @date 2020-09-22 09:59
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZBGL + "ZFZBGL_ZFCL_PFJGHXXB")
public class PfjghxxbVo extends BaseEntity<String> {

    /***
     * 车辆配发及归还信息ID
     */
    @TableId("PFJGHXXID")
    private String pfjghxxid;

    /******
     * 车辆信息登记ID
     */
    private String zfclid;

    /******
     * 领用单位名称
     */
    private String lydwmc;

    /******
     * 领用单位ID
     */
    private String lydwid;

    /******
     * 领用人
     */
    private String lyr;

    /******
     * 配发日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date pfrq;

    /******
     * 配发登记人
     */
    private String pfdjr;

    /******
     * 归还人
     */
    private String ghr;

    /******
     * 归还日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date ghrq;

    /******
     * 归还登记人
     */
    private String ghdjr;

    @Override
    public String getId() {
        return this.pfjghxxid;
    }

    @Override
    public void setId(String id) {
        this.pfjghxxid = id;
    }
}
