package com.kdgcsoft.jt.xzzf.dubbo.zbgl.zfcl.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className DcxxbVo
 * @author hufanghua
 * @description 执法车辆调出信息表实体
 * @version 1.0
 * @date 2020-09-22 09:59
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZBGL + "ZFZBGL_ZFCL_DCXXB")
public class DcxxbVo extends BaseEntity<String> {

    /***
     * 车辆库存状态日志ID
     */
    @TableId("DCXXID")
    private String dcxxid;

    /******
     * 车辆信息登记ID
     */
    private String zfclid;

    /******
     * 调出日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date dcrq;

    /******
     * 调出单位名称
     */
    private String dcdwmc;

    /******
     * 调出单位ID
     */
    private String dcdwid;

    /******
     * 调出单位登记人
     */
    private String dcdwdjr;

    /******
     * 调入单位名称
     */
    private String drdwmc;

    /******
     * 调入单位ID
     */
    private String drdwid;

    /******
     * 调入单位接收人
     */
    private String drdwjsr;

    /******
     * 调入状态
     */
    private String drzt;

    @Override
    public String getId() {
        return this.dcxxid;
    }

    @Override
    public void setId(String id) {
        this.dcxxid = id;
    }
}
