package com.kdgcsoft.jt.xzzf.dubbo.zbgl.zfcl.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ClsyxxVo
 * @author hufanghua
 * @description 车辆审验信息实体类
 * @version 1.0
 * @date 2020-06-09 10:18
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZBGL + "ZFZBGL_ZFCL_CLSYXX")
public class ClsyxxVo extends BaseEntity<String> {
    /******
     * 车辆审验信息id
     */
    @TableId("CLSYXXID")
    private String clsyxxid;

    /******
     * 执法车辆id
     */
    private String zfclid;

    /******
     * 警灯使用证信息ID
     */
    private String jdsyzxxid;

    /******
     * 警灯使用证编号
     */
    private String jdsyzbh;

    /******
     * 车型
     */
    private String cx;

    /******
     * 车型文本值
     */
    @TableField(exist = false)
    private String cxText;

    /******
     * 车辆使用单位
     */
    private String clsydw;

    /******
     * 车辆使用单位id
     */
    private String clsydwid;

    /******
     * 执法类别
     */
    private String zflb;

    /******
     * 车牌号码
     */
    private String cphm;

    /******
     * 厂牌型号
     */
    private String cpxh;

    /******
     * 发动机号
     */
    private String fdjh;

    /******
     * 车辆识别代号
     */
    private String clsbdh;

    /******
     * 标志示警灯规范情况
     */
    private String bzsjdgfqk;

    /******
     * 违规使用情况
     */
    private String wgsyqk;

    /******
     * 初审情况
     */
    private String csqk;

    /******
     * 复审情况
     */
    private String fsqk;

    /******
     * 审验结果
     */
    private String syjg;

    /******
     * 登记人
     */
    private String djr;

    /******
     * 登记日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date djrq;

    /******
     * 备注
     */
    private String bz;

    /******
     * 示警灯使用证管理-根据使用证编号准确查询车辆审验情况
     */
    @TableField(exist = false)
    private String syzbh;

    /******
     * 执法车辆登记-根据车牌号码准确查询车辆审验情况
     */
    @TableField(exist = false)
    private String zfclCphm;

    /******
     * 上传附件详情
     */
    @TableField(exist = false)
    private String attachmentDetail;

    @Override
    public String getId() {
        return this.clsyxxid;
    }

    @Override
    public void setId(String id) {
        this.clsyxxid = id;
    }
}
