package com.kdgcsoft.jt.xzzf.dubbo.zbgl.zfcl.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ClsyqkdjVo
 * @author hufanghua
 * @description 车辆使用情况登记实体类
 * @version 1.0
 * @date 2020-06-02 10:18
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZBGL + "ZFZBGL_ZFCL_CLSYQKDJ")
public class ClsyqkdjVo extends BaseEntity<String> {
    /******
     * 车辆使用情况ID
     */
    @TableId("CLSYQKID")
    private String clsyqkid;

    /******
     * 执法车辆id
     */
    private String zfclid;

    /******
     * 车牌号码
     */
    private String cphm;

    /******
     * 使用年月-开始日期：默认为上一次登记的结束日期延后一天
     */
    @DateTimeFormat(pattern = "yyyy-MM")
    @JSONField(format = "yyyy-MM")
    private Date ny;

    /******
     * 当前里程
     */
    private String dqlc;

    /******
     * 使用里程
     */
    private String sylc;

    /******
     * 期间维修费用
     */
    private String qjwxfy;

    /******
     * 期间事故次数
     */
    private String qjsgcs;

    /******
     * 登记人
     */
    private String djr;

    /******
     * 登记日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date djrq;

    /******
     * 备注
     */
    private String bz;

    /******
     * 车辆类型
     */
    @TableField(exist = false)
    private String cllx;

    /******
     * 车辆类型文本
     */
    @TableField(exist = false)
    private String cllxText;

    /******
     * 车型
     */
    @TableField(exist = false)
    private String cx;

    /******
     * 车型文本
     */
    @TableField(exist = false)
    private String cxText;

    /******
     * 车辆单位
     */
    @TableField(exist = false)
    private String cldw;

    /******
     * 执法车辆登记-根据车牌号码准确查询车辆月度使用情况
     */
    @TableField(exist = false)
    private String zfclCphm;

    /******
     * 上传附件详情
     */
    @TableField(exist = false)
    private String attachmentDetail;

    @Override
    public String getId() {
        return this.clsyqkid;
    }

    @Override
    public void setId(String id) {
        this.clsyqkid = id;
    }
}
