package com.kdgcsoft.jt.xzzf.dubbo.zbgl.zfcl.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ClkcztrzVo
 * @author hufanghua
 * @description 执法车辆库存状态日志实体
 * @version 1.0
 * @date 2020-09-22 09:59
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZBGL + "ZFZBGL_ZFCL_CLKCZTRZ")
public class ClkcztrzVo extends BaseEntity<String> {

    /***
     * 车辆库存状态日志ID
     */
    @TableId("CLKCZTRZID")
    private String clkcztrzid;

    /******
     * 车辆信息登记ID
     */
    private String zfclid;

    /******
     * 记录日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date jlrq;

    /******
     * 库存状态
     */
    private String kczt;

    @Override
    public String getId() {
        return this.clkcztrzid;
    }

    @Override
    public void setId(String id) {
        this.clkcztrzid = id;
    }
}
