package com.kdgcsoft.jt.xzzf.dubbo.zbgl.zfcb.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.excel.jxls.ExcelRowInfo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.zfcb.entity.ZfcbVo;

import java.util.List;
import java.util.Map;

/****
 * @className ZfcbService
 * @author hufanghua
 * @description 执法船舶Service接口层接口
 * @version 1.0
 * @date 2020-07-28 15:03
 */
public interface ZfcbService {
    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param orgId 登录人所在机构
     * @return
     */
    public Page<ZfcbVo> page(Page<ZfcbVo> page, ZfcbVo entity,String orgId);

    /*****
     * 保存或修改执法船舶数据
     * @param entity 实体类
     * @param user 当前登录用户
     * @param isCreate 是否创建
     */
    public void saveOrUpdate(ZfcbVo entity, SysUser user, boolean isCreate);

    /*****
     * 获取执法船舶
     * @param id 主键ID
     * @return
     */
    public ZfcbVo getEntityInfoById(String id);

    /*****
     * 删除执法船舶
     * @param ids 主键Id集合
     */
    public void deleteDataByIds(String ids, SysUser user);

    /*****
     * 导入Excel
     * @param dataList
     * @param user
     * @return
     */
    public ExcelRowInfo importExcel(List<Map<String, Object>> dataList, SysUser user);


    /*****
     * 查询船舶类型图表数据
     * @param orgId 单位id
     * @param flag 是否查询子机构标识
     * @return
     */
    public List<ZfcbVo> queryCblxEchart(String orgId,String flag);


    /*****
     * 查询船舶类型图表数据
     * @param orgId 单位id
     * @param flag 是否查询子机构标识
     * @return
     */
    public ZfcbVo queryZfcbCount(String orgId,String flag);

    /*****
     * 根据id更新管理负责人
     * @param entity 车辆实体类
     * @return
     */
    public void updateGlfzr(ZfcbVo entity,SysUser user);

}
