package com.kdgcsoft.jt.xzzf.dubbo.zbgl.zfcb.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.zfcb.entity.CbzjVo;

import java.util.List;
import java.util.Map;

/****
 * @className CbzjService
 * @author hufanghua
 * @description 船舶主机Service接口层接口
 * @version 1.0
 * @date 2020-07-28 15:03
 */
public interface CbzjService {
    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @return
     */
    public Page<CbzjVo> page(Page<CbzjVo> page, CbzjVo entity);

    /*****
     * 保存或修改船舶主机数据
     * @param entity 实体类
     * @param user 当前登录用户
     * @param isCreate 是否创建
     */
    public void saveOrUpdate(CbzjVo entity, SysUser user, boolean isCreate);

    /*****
     * 获取船舶主机
     * @param id 主键ID
     * @return
     */
    public CbzjVo getEntityInfoById(String id);

    /*****
     * 删除船舶主机
     * @param ids 主键Id集合
     */
    public void deleteDataByIds(String ids, SysUser user);

}
