package com.kdgcsoft.jt.xzzf.dubbo.zbgl.zfcb.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ZfcbVo
 * @author hufanghua
 * @description 执法船舶实体
 * @version 1.0
 * @date 2020-07-28 09:59
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZBGL + "ZFZBGL_ZFCB_ZFCB")
public class ZfcbVo extends BaseEntity<String> {

    /***
     * 执法船舶ID
     */
    @TableId("ZFCBID")
    private String zfcbid;

    /******
     * 船舶类型代码
     */
    private String cblxdm;

    /******
     * 船籍港代码
     */
    private String cjgdm;

    /******
     * 船舶登记机构代码
     */
    private String cbdjjgdm;

    /******
     * 船名
     */
    private String cm;

    /******
     * 船籍港
     */
    private String cjg;

    /******
     * 船籍港
     */
    @TableField(exist = false)
    private String cjgText;

    /******
     * 船舶识别号
     */
    private String cbsbh;

    /******
     * 船检登记号
     */
    private String cjdjh;

    /******
     * MMSI
     */
    private String mmsi;

    /******
     * IMO
     */
    private String imo;

    /******
     * 船舶登记机构
     */
    private String cbdjjg;

    /******
     * 船舶登记机构文本
     */
    @TableField(exist = false)
    private String cbdjjgText;

    /******
     * 总吨位
     */
    private String zdw;

    /******
     * 净吨位
     */
    private String jdw;

    /******
     * 船舶类型
     */
    private String cblx;

    /******
     * 船舶类型文本值
     */
    @TableField(exist = false)
    private String cblxText;

    /******
     * 船舶类型说明
     */
    private String cblxsm;

    /******
     * 船舶呼号
     */
    private String cbhh;

    /******
     * 建造完工日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date jzwgrq;

    /******
     * 改建日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date gjrq;


    /******
     * 船舶制造厂
     */
    private String cbzzc;

    /******
     * 船舶改建厂
     */
    private String cbgjc;

    /******
     * 总长
     */
    private String zc;

    /******
     * 船长
     */
    private String cc;


    /******
     * 满载水线长
     */
    private String mzsxc;

    /******
     * 船宽
     */
    private String ck;

    /******
     * 型深
     */
    private String xs;

    /******
     * 满载吃水
     */
    private String mzcs;

    /******
     * 满载排水量
     */
    private String mzpsl;

    /******
     * 空载排水量
     */
    private String kzpsl;

    /******
     * 参考载货量
     */
    private String ckzhl;

    /******
     * 航区
     */
    private String hq;

    /******
     * 航区文本值
     */
    @TableField(exist = false)
    private String hqText;

    /******
     * 船体材料
     */
    private String ctcl;

    /******
     * 船体材料文本值
     */
    @TableField(exist = false)
    private String ctclText;

    /******
     * 甲板材料
     */
    private String jbcl;

    /******
     * 甲板层数
     */
    private String jbcs;

    /******
     * 水密横舱壁数
     */
    private String smhcbs;

    /******
     * 双层底位置
     */
    private String scdwz;

    /******
     * 结构型式
     */
    private String jgxs;

    /******
     * 固定压载数量
     */
    private String gdyzsl;

    /******
     * 固定压载(位置)
     */
    private String gdyzwz;

    /******
     * 备注
     */
    private String bz;

    /******
     * 登记日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date djrq;

    /******
     * 登记人
     */
    private String djr;

    /******
     * 登记单位id
     */
    private String djdwid;

    /******
     * 登记单位名称
     */
    private String djdwmc;

    /******
     * 使用单位id
     */
    private String sydwid;

    /******
     * 使用单位名称
     */
    private String sydwmc;

    /******
     * 管理负责人
     */
    private String glfzr;

    /******
     * 管理负责人id
     */
    private String glfzrid;

    /******
     * 船舶主机信息
     */
    @TableField(exist = false)
    private String detailInfo;

    /******
     * 主机类型
     */
    @TableField(exist = false)
    private String zjlx;
    /******
     * 主机型号
     */
    @TableField(exist = false)
    private String zjxh;
    /******
     * 制造日期
     */
    @TableField(exist = false)
    private Date zzrq;
    /******
     * 机号
     */
    @TableField(exist = false)
    private String jh;
    /******
     * 额定功率
     */
    @TableField(exist = false)
    private String edgl;
    /******
     * 额定转速
     */
    @TableField(exist = false)
    private String edzs;
    /******
     * 制造厂
     */
    @TableField(exist = false)
    private String zzc;

    /******
     * 数量统计
     */
    @TableField(exist = false)
    private String count;

    @Override
    public String getId() {
        return this.zfcbid;
    }

    @Override
    public void setId(String id) {
        this.zfcbid = id;
    }
}
