package com.kdgcsoft.jt.xzzf.dubbo.zbgl.zfcb.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className CbzjVo
 * @author hufanghua
 * @description 执法船舶主机实体
 * @version 1.0
 * @date 2020-07-28 09:59
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZBGL + "ZFZBGL_ZFCB_CBZJ")
public class CbzjVo extends BaseEntity<String> {

    /***
     * 船舶主机主键ID
     */
    @TableId("CBZJID")
    private String cbzjid;

    /******
     * 执法船舶主键ID
     */
    private String zfcbid;

    /******
     * 主机型号
     */
    private String zjxh;

    /***
     * 主机类型
     */
    private String zjlx;

    /******
     * 机号
     */
    private String jh;

    /***
     * 额定功率(kW)
     */
    private String edgl;

    /******
     * 额定转速(r/min)
     */
    private String edzs;

    /***
     * 制造日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date zzrq;

    /******
     * 制造厂
     */
    private String zzc;

    /******
     * 备注
     */
    private String bz;

    /******
     * 编号
     */
    private String bh;

    /***
     * 主机类型文本值
     */
    @TableField(exist = false)
    private String zjlxText;

    @Override
    public String getId() {
        return this.cbzjid;
    }

    @Override
    public void setId(String id) {
        this.cbzjid = id;
    }
}
