package com.kdgcsoft.jt.xzzf.dubbo.zbgl.road.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.excel.jxls.ExcelRowInfo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.api.entity.RoadLcVo;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.road.entity.SjdVo;

import java.util.List;
import java.util.Map;

/****
 * @className SjdService
 * @author Chris
 * @description 示警灯Service接口层接口
 * @version 1.0
 * @date 2020-05-06 15:10
 */
public interface SjdService {

    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    public Page<SjdVo> page(Page<SjdVo> page, SjdVo entity, String curUserOrgId);

    /*****
     * 导出查询
     * @param entity 实体类
     * @param ids 主键集合
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    public List<SjdVo> export(SjdVo entity, String ids, String curUserOrgId);

    /*****
     * 保存示警灯数据
     * @param entity 实体类
     * @param user 当前登录用户
     * @param isCreate 是否创建
     */
    public void saveOrUpdate(SjdVo entity, SysUser user, boolean isCreate);

    /*****
     * 获取示警灯信息
     * @param id 主键ID
     * @return
     */
    public SjdVo getEntityInfoById(String id);

    /*****
     * 删除示警灯信息
     * @param ids 主键Id集合
     */
    public void deleteDataByIds(String ids, SysUser user);

    /******
     * 获取示警灯信息
     * @param filter 过滤条件
     * @param orgId 组织机构id
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    public List<RoadLcVo> queryRoadLcEntityDataList(String filter, String orgId, String curUserOrgId);

    /*****
     * 导入Excel
     * @param dataList
     * @param user
     * @return
     */
    public ExcelRowInfo importExcel(List<Map<String, Object>> dataList, SysUser user);
}
