package com.kdgcsoft.jt.xzzf.dubbo.zbgl.road.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.excel.jxls.ExcelRowInfo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.api.entity.RoadLcVo;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.road.entity.SfzVo;

import java.util.List;
import java.util.Map;

/****
 * @className SfzService
 * @author hufanghua
 * @description 收费站Service接口层接口
 * @version 1.0
 * @date 2020-04-21 15:03
 */
public interface SfzService {

    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    public Page<SfzVo> page(Page<SfzVo> page, SfzVo entity, String curUserOrgId);

    /*****
     * 导出查询
     * @param entity 实体类
     * @param ids 主键集合
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    public List<SfzVo> export(SfzVo entity, String ids, String curUserOrgId);

    /*****
     * 保存收费站数据
     * @param entity 实体类
     * @param user 当前登录用户
     * @param isCreate 是否创建
     */
    public void saveOrUpdate(SfzVo entity, SysUser user, boolean isCreate);

    /*****
     * 获取收费站信息
     * @param id 主键ID
     * @return
     */
    public SfzVo getEntityInfoById(String id);

    /*****
     * 删除收费站信息
     * @param ids 主键Id集合
     */
    public void deleteDataByIds(String ids, SysUser user);

    /******
     * 获取收费站信息
     * @param filter 过滤条件
     * @param orgId 组织机构id
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    public List<RoadLcVo> queryRoadLcEntityDataList(String filter, String orgId, String curUserOrgId);

    /*****
     * 导入Excel
     * @param dataList
     * @param user
     * @return
     */
    public ExcelRowInfo importExcel(List<Map<String, Object>> dataList, SysUser user);
}
