package com.kdgcsoft.jt.xzzf.dubbo.zbgl.road.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.excel.jxls.ExcelRowInfo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.api.entity.RoadLcVo;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.road.entity.LxVo;

import java.util.List;
import java.util.Map;

/****
 * @className LxService
 * @author hufanghua
 * @description 路线Service接口层接口
 * @version 1.0
 * @date 2020-04-14 15:03
 */
public interface LxService {

    /*****
     * 巡查路线分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    public Page<LxVo> page(Page<LxVo> page, LxVo entity, String curUserOrgId);

    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    public Page<LxVo> queryLclxPage(Page<LxVo> page, LxVo entity, String curUserOrgId);

    /*****
     * 导出查询
     * @param entity 实体类
     * @param ids 主键集合
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    public List<LxVo> export(LxVo entity, String ids, String curUserOrgId);

    /*****
     * 保存路线数据
     * @param entity 实体类
     * @param user 当前登录用户
     * @param isCreate 是否创建
     */
    public void saveOrUpdate(LxVo entity, SysUser user, boolean isCreate);

    /*****
     * 获取路线信息
     * @param id 主键ID
     * @return
     */
    public LxVo getEntityInfoById(String id);

    /*****
     * 删除路线信息
     * @param ids 主键Id集合
     */
    public void deleteDataByIds(String ids, SysUser user);

    /******
     * 获取路线编码
     * @return
     */
    public String getNextOrder();

    /******
     * 获取路段信息
     * @param filter 过滤条件
     * @param orgId 组织机构id
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    public List<RoadLcVo> queryRoadLcEntityDataList(String filter, String orgId, String curUserOrgId);

    /*****
     * 导入Excel
     * @param dataList
     * @param user
     * @return
     */
    public ExcelRowInfo importExcel(List<Map<String, Object>> dataList, SysUser user);

    /*****
     * 查询机构下路线信息--协同办案
     * @param OrgId 组织机构Id
     * @return
     */
    public List<LxVo> queryLxInfoByOrgId(String OrgId);
}
