package com.kdgcsoft.jt.xzzf.dubbo.zbgl.road.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.excel.jxls.ExcelRowInfo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.api.entity.RoadLqVo;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.road.entity.JzwVo;

import java.util.List;
import java.util.Map;

/****
 * @className JzwService
 * @author Chris
 * @description 建筑控制区建筑物服务层接口
 * @version 1.0
 * @date 2020-04-21 17:54
 */
public interface JzwService {
    /******
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    public Page<JzwVo> page(Page<JzwVo> page, JzwVo entity, String curUserOrgId);

    /****
     * 导出查询
     * @param entity
     * @param ids
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    public List<JzwVo> export(JzwVo entity, String ids, String curUserOrgId);

    /*****
     * 保存建筑物数据
     * @param entity 实体类
     * @param user 当前登录用户
     * @param isCreate 是否创建
     */
    public void saveOrUpdate(JzwVo entity, SysUser user, boolean isCreate);


    /*****
     * 获取非路产信息
     * @param id 非路产Id
     * @returnID
     */
    public JzwVo getEntityInfoById(String id);

    /*****
     * 删除建筑物信息
     * @param ids ids集合
     */
    public void deleteDataByIds(String ids, SysUser user);

    /******
     * 获取建筑物编码
     * @return
     */
    public String getNextOrder();

    /******
     * 获取建筑物信息
     * @param filter 过滤条件
     * @param orgId 组织机构id
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    public List<RoadLqVo> queryRoadLqEntityDataList(String filter, String orgId, String curUserOrgId);

    /*****
     * 导入Excel
     * @param dataList
     * @param user
     * @return
     */
    public ExcelRowInfo importExcel(List<Map<String, Object>> dataList, SysUser user);
}
