package com.kdgcsoft.jt.xzzf.dubbo.zbgl.road.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.excel.jxls.ExcelRowInfo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.api.entity.RoadLcVo;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.road.entity.JtbzVo;

import java.util.List;
import java.util.Map;

/****
 * @className JtbzService
 * @author hufanghua
 * @description 交通标志Service接口层接口
 * @version 1.0
 * @date 2020-04-21 15:03
 */
public interface JtbzService {

    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    public Page<JtbzVo> page(Page<JtbzVo> page, JtbzVo entity, String curUserOrgId);

    /*****
     * 交通标志查询
     * @param entity 实体类
     * @param ids 主键集合
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    public List<JtbzVo> export(JtbzVo entity, String ids, String curUserOrgId);

    /*****
     * 保存交通标志数据
     * @param entity 实体类
     * @param user 当前登录用户
     * @param isCreate 是否创建
     */
    public void saveOrUpdate(JtbzVo entity, SysUser user, boolean isCreate);

    /*****
     * 获取交通标志信息
     * @param id 主键ID
     * @return
     */
    public JtbzVo getEntityInfoById(String id);

    /*****
     * 删除交通标志信息
     * @param ids 主键Id集合
     */
    public void deleteDataByIds(String ids, SysUser user);

    /******
     * 获取交通标志信息
     * @param filter 过滤条件
     * @param orgId 组织机构id
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    public List<RoadLcVo> queryRoadLcEntityDataList(String filter, String orgId, String curUserOrgId);

    /******
     * 获取总数
     * @param jtbzlxId 交通标志类型Id
     * @return
     */
    public Integer getTotalCountByJtbzlxId(String jtbzlxId);

    /*****
     * 导入Excel
     * @param dataList
     * @param user
     * @return
     */
    public ExcelRowInfo importExcel(List<Map<String, Object>> dataList, SysUser user);
}
