package com.kdgcsoft.jt.xzzf.dubbo.zbgl.road.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.excel.jxls.ExcelRowInfo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.api.entity.RoadLqVo;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.road.entity.GgpVo;

import java.util.List;
import java.util.Map;

/****s
 * @className GgpService
 * @author Chris
 * @description 广告牌服务层接口
 * @version 1.0
 * @date 2020-04-16 17:29
 */
public interface GgpService {
    /******
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    public Page<GgpVo> page(Page<GgpVo> page, GgpVo entity, String curUserOrgId);

    /****
     * 导出查询
     * @param entity
     * @param ids
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    public List<GgpVo> export(GgpVo entity, String ids, String curUserOrgId);

    /*****
     * 保存广告牌数据
     * @param entity 实体类
     * @param user 当前登录用户
     * @param isCreate 是否创建
     */
    public void saveOrUpdate(GgpVo entity, SysUser user, boolean isCreate);

    /*****
     * 获取非非路产信息
     * @param id 路权Id
     * @returnID
     */
    public GgpVo getEntityInfoById(String id);

    /*****
     * 删除广告牌信息
     * @param ids ids集合
     */
    public void deleteDataByIds(String ids, SysUser user);

    /******
     * 获取广告牌信息
     * @param filter 过滤条件
     * @param orgId 组织机构id
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    public List<RoadLqVo> queryRoadLqEntityDataList(String filter, String orgId, String curUserOrgId);

    /*****
     * 导入Excel
     * @param dataList
     * @param user
     * @return
     */
    public ExcelRowInfo importExcel(List<Map<String, Object>> dataList, SysUser user);
}
