package com.kdgcsoft.jt.xzzf.dubbo.zbgl.road.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.excel.jxls.ExcelRowInfo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.api.entity.RoadLcVo;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.road.entity.FsssVo;

import java.util.List;
import java.util.Map;

/****
 * @className FsssService
 * @author hufanghua
 * @description 附属设施Service接口层接口
 * @version 1.0
 * @date 2020-05-15 15:03
 */
public interface FsssService {

    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    public Page<FsssVo> page(Page<FsssVo> page, FsssVo entity, String curUserOrgId);

    /*****
     * 导出查询
     * @param entity 实体类
     * @param ids 主键集合
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    public List<FsssVo> export(FsssVo entity, String ids, String curUserOrgId);

    /*****
     * 保存附属设施数据
     * @param entity 实体类
     * @param user 当前登录用户
     * @param isCreate 是否创建
     */
    public void saveOrUpdate(FsssVo entity, SysUser user, boolean isCreate);

    /*****
     * 获取附属设施信息
     * @param id 主键ID
     * @return
     */
    public FsssVo getEntityInfoById(String id);

    /*****
     * 删除附属设施信息
     * @param ids ID集合
     * @param user 当前登录用户
     */
    public void deleteDataByIds(String ids, SysUser user);

    /******
     * 获取附属设施信息
     * @param filter 过滤条件
     * @param orgId 组织机构id
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    public List<RoadLcVo> queryRoadLcEntityDataList(String filter, String orgId, String curUserOrgId);

    /******
     * 获取总数
     * @param fssslxId 附属设施类型Id
     * @return
     */
    public Integer getTotalCountByFssslxId(String fssslxId);

    /*****
     * 导入Excel
     * @param dataList
     * @param user
     * @return
     */
    public ExcelRowInfo importExcel(List<Map<String, Object>> dataList, SysUser user);
}
