package com.kdgcsoft.jt.xzzf.dubbo.zbgl.road.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.excel.jxls.ExcelRowInfo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.api.entity.RoadLcVo;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.road.entity.BxlhlVo;

import java.util.List;
import java.util.Map;

/****
 * @className BxlhlService
 * @author Chris
 * @description 波形梁护栏Service接口层接口
 * @version 1.0
 * @date 2020-05-06 15:10
 */
public interface BxlhlService {

    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    Page<BxlhlVo> page(Page<BxlhlVo> page, BxlhlVo entity, String curUserOrgId);

    /*****
     * 导出查询
     * @param entity 实体类
     * @param ids 主键集合
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    List<BxlhlVo> export(BxlhlVo entity, String ids, String curUserOrgId);

    /*****
     * 保存波形梁护栏数据
     * @param entity 实体类
     * @param user 当前登录用户
     * @param isCreate 是否创建
     */
    void saveOrUpdate(BxlhlVo entity, SysUser user, boolean isCreate);

    /*****
     * 获取波形梁护栏信息
     * @param id 主键ID
     * @return
     */
    BxlhlVo getEntityInfoById(String id);

    /*****
     * 删除波形梁护栏信息
     * @param ids 主键Id集合
     */
    void deleteDataByIds(String ids, SysUser user);

    /******
     * 获取波形梁护栏信息
     * @param filter 过滤条件
     * @param orgId 组织机构id
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    List<RoadLcVo> queryRoadLcEntityDataList(String filter, String orgId, String curUserOrgId);

    /*****
     * 导入Excel
     * @param dataList
     * @param user
     * @return
     */
    ExcelRowInfo importExcel(List<Map<String, Object>> dataList, SysUser user);
}
