package com.kdgcsoft.jt.xzzf.dubbo.zbgl.road.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.excel.jxls.ExcelRowInfo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.api.entity.RoadLcVo;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.road.entity.BmzVo;

import java.util.List;
import java.util.Map;

/****
 * @className BmzService
 * @author hufanghua
 * @description 百米桩Service接口层接口
 * @version 1.0
 * @date 2020-04-29 15:03
 */
public interface BmzService {

    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    Page<BmzVo> page(Page<BmzVo> page, BmzVo entity, String curUserOrgId);

    /*****
     * 导出查询
     * @param entity 实体类
     * @param ids 主键集合
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    List<BmzVo> export(BmzVo entity, String ids, String curUserOrgId);

    /*****
     * 保存百米桩数据
     * @param entity 实体类
     * @param user 当前登录用户
     * @param isCreate 是否创建
     */
    void saveOrUpdate(BmzVo entity, SysUser user, boolean isCreate);

    /*****
     * 获取百米桩信息
     * @param id 主键ID
     * @return
     */
    BmzVo getEntityInfoById(String id);

    /*****
     * 删除百米桩信息
     * @param ids 主键Id集合
     * @param user 当前登录用户
     */
    void deleteDataByIds(String ids, SysUser user);

    /******
     * 获取百米桩信息
     * @param filter 过滤条件
     * @param orgId 组织机构id
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    List<RoadLcVo> queryRoadLcEntityDataList(String filter, String orgId, String curUserOrgId);

    /*****
     * 导入Excel
     * @param dataList
     * @param user
     * @return
     */
    ExcelRowInfo importExcel(List<Map<String, Object>> dataList, SysUser user);

}
