package com.kdgcsoft.jt.xzzf.dubbo.zbgl.road.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ZczVo
 * @author hufanghua
 * @description 治超站实体类
 * @version 1.0
 * @date 2020-04-30 15:23
 */

@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZBGL + "ZBGL_LCLQ_ZCZ")
public class ZczVo extends BaseEntity<String> {

    /***
     *路产Id
     */
    @TableId("LCID")
    private String lcId;

    /******
     * 路产分类id
     */
    private String lcflid;

    /******
     * 路产分类名称
     */
    private String lcflmc;

    /******
     * 名称
     */
    private String mc;

    /******
     * 编码
     */
    private String bm;

    /******
     * 所在路线代码
     */
    private String szlxdm;

    /******
     * 设施所在桩号
     */
    private String ssszzh;

    /******
     * 路政机构
     */
    private String ssdwmc;

    /******
     * 路政机构ID
     */
    private String ssdwid;

     /******
     * 管理单位主键
     */
    private String gldwid;

    /******
     * 管理单位主键
     */
    private String gldwmc;

    /******
     * 类型
     */
    private String lx;

    /******
     * 设置方向
     */
    private String szfx;

    /******
     * 监控摄像机数量
     */
    private String jksxjsl;

    /******
     * 有无高速预检
     */
    private String ywgsyj;

    /******
     * 预检设备编号
     */
    private String yjsbbh;

    /******
     * 精检设备编号
     */
    private String jjsbbh;

    /******
     * 复检设备编号
     */
    private String fjsbbh;

    /******
     * 检测车道净高
     */
    private String jccdjg;

    /******
     * 检车车道净宽
     */
    private String jccdjk;

    /******
     * 有无车道拍摄设施
     */
    private String ywcdpsss;

    /******
     * 距离中心线距离
     */
    private String jlzxxjl;

    /******
     * 站区建筑面积
     */
    private String zqjzmj;

    /******
     * 卸载场面积
     */
    private String xzcmj;

    /******
     * 批准文号
     */
    private String pzwh;

    /******
     * 批准时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date pzsj;

    /******
     * 地址
     */
    private String dz;

    /******
     * 负责人
     */
    private String fzr;

    /******
     * 联系电话
     */
    private String lxdh;

    /******
     * 传真
     */
    private String cz;

    /******
     * 是否24小时值班
     */
    private String sf24xszb;

    /******
     * 是否联网
     */
    private String sflw;

    /******
     * 参与执法的其他部门
     */
    private String cyzfdqtbm;

    /******
     * 设置日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date szrq;

    /******
     * 上传图片
     */
    private String sctp;

    /******
     * 经度
     */
    private String jd;

    /******
     * 纬度
     */
    private String wd;

    /******
     * 上传图片
     */
    private String lcbz;

    /******
     * 有无高速预检文本值
     */
    @TableField(exist = false)
    private String ywgsyjText;

    /******
     * 有无车道拍摄设施文本值
     */
    @TableField(exist = false)
    private String ywcdpsssText;

    /******
     * 是否24小时值班文本值
     */
    @TableField(exist = false)
    private String sf24xszbText;

    /******
     * 是否联网文本值
     */
    @TableField(exist = false)
    private String sflwText;

    @Override
    public String getId() {
        return this.lcId;
    }

    @Override
    public void setId(String id) {
        this.lcId = id;
    }
}
