package com.kdgcsoft.jt.xzzf.dubbo.zbgl.road.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.util.List;

/****
 * @className QlVo
 * @author hufanghua
 * @description 桥梁实体类
 * @version 1.0
 * @date 2020-04-14 15:23
 */

@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZBGL + "ZBGL_LCLQ_QL")
public class QlVo extends BaseEntity<String> {

    /***
     *非路产Id
     */
    @TableId("LCID")
    private String lcId;

    /******
     * 非路产分类id
     */
    private String lcflid;

    /******
     * 非路产分类名称
     */
    private String lcflmc;

    /******
     * 所属单位名称
     */
    private String ssdwmc;

    /******
     * 所属单位主键
     */
    private String ssdwid;

     /******
     * 管理单位主键
     */
    private String gldwid;

    /******
     * 管理单位主键
     */
    private String gldwmc;

    /******
     * 桥梁名称
     */
    private String qlmc;

    /******
     * 桥梁总长
     */
    private String qlzc;

    /******
     * 中心桩号
     */
    private String zxzh;

    /******
     * 上传图片
     */
    private String sctp;

    /******
     * 桥梁经度
     */
    private String qljd;

    /******
     * 桥梁纬度
     */
    private String qlwd;

    /******
     * 非路产备注
     */
    private String lcbz;

    /**
     * excel导入数据集合
     */
    @TableField(exist = false)
    private List<QlVo> daoRuData;

    /**
     * excel导入数据为空提示
     */
    @TableField(exist = false)
    private List<String> failNull;

    /**
     * excel数据格式错误提示
     */
    @TableField(exist = false)
    private List<String> failFormat;

    /**
     * excel数据不存在提示
     */
    @TableField(exist = false)
    private List<String> failNotExist;

    @Override
    public String getId() {
        return this.lcId;
    }

    @Override
    public void setId(String id) {
        this.lcId = id;
    }
}
