package com.kdgcsoft.jt.xzzf.dubbo.zbgl.road.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

/****
 * @className LxVo
 * @author hufanghua
 * @description 路线实体类
 * @version 1.0
 * @date 2020-04-28 15:23
 */

@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZBGL + "ZBGL_LCLQ_LX")
public class LxVo extends BaseEntity<String> {

    /***
     *路产Id
     */
    @TableId("LCID")
    private String lcId;

    /******
     * 路产分类id
     */
    private String lcflid;

    /******
     * 路产分类名称
     */
    private String lcflmc;

    /******
     * 编码
     */
    private String lxbm;

    /******
     * 路线名称
     */
    private String lxmc;

    /******
     * 所在行政区划
     */
    private String szxzqh;

    /******
     * 所属单位ID
     */
    private String ssdwid;

     /******
     * 管理单位主键
     */
    private String gldwid;

    /******
     * 管理单位主键
     */
    private String gldwmc;

    /******
     * 所属单位
     */
    private String ssdwmc;

    /******
     * 起点名称
     */
    private String qdmc;

    /******
     * 终点名称
     */
    private String zdmc;

    /******
     * 起点桩号
     */
    private String qdzh;

    /******
     * 终点桩号
     */
    private String zdzh;

    /******
     * 车道分类
     */
    private String cdfl;

    /******
     * 面层类型
     */
    private String mclx;

    /******
     * 路面宽度
     */
    private String lmkd;

    /******
     * 设计时速
     */
    private String sjss;

    /******
     * 地貌汉字
     */
    private String dmhz;

    /******
     * 上传图片
     */
    private String sctp;

    /******
     * 止点经度
     */
    private String zdjd;

    /******
     * 止点纬度
     */
    private String zdwd;

    /******
     * 经度
     */
    private String qdjd;

    /******
     * 纬度
     */
    private String qdwd;

    /******
     * 路产备注
     */
    private String lcbz;

    /******
     *  机构范围
     */
    private String range;

    @Override
    public String getId() {
        return this.lcId;
    }

    @Override
    public void setId(String id) {
        this.lcId = id;
    }
}
