package com.kdgcsoft.jt.xzzf.dubbo.zbgl.road.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className JzwVo
 * @author Chris
 * @description 建筑控制区建筑物
 * @version 1.0
 * @date 2020-04-21 17:23
 */
@Data
@TableName(DataSourceConstant.DATA_SOURCE_ZBGL + "ZBGL_LCLQ_JZKZQJZW")
public class JzwVo extends BaseEntity<String> {
    /***
     *非路产ID
     */
    @TableId("LQID")
    private String lqId;

    /***
     * 非路产分类ID
     */
    private String lqflid;

    /***
     * 非路产分类名称
     */
    private String lqflmc;

    /***
     * 路政机构
     */
    private String ssdwmc;

    /***
     * 路政机构
     */
    private String ssdwid;

     /******
     * 管理单位主键
     */
    private String gldwid;

    /******
     * 管理单位主键
     */
    private String gldwmc;

    /***
     * 编码
     */
    private String bm;

    /***
     * 名称
     */
    private String mc;

    /***
     * 所在路线代码
     */
    private String szlxdm;

    /***
     * 建(构)筑物所在桩号
     */
    private String jgzwszzh;

    /***
     * 距路中心距离(M)
     */
    private String jlzxjl;

    /***
     * 存在原因
     */
    private String czyy;

    /***
     * 距同侧路缘石(隔离栅)距离(M)
     */
    private String jtclysglsjl;

    /***
     * 所在县乡(镇)村详址
     */
    private String szxxzcxz;


    /***
     * 设置方向
     */
    private String szfx;

    /***
     * 建(构)筑物类型
     */
    private String jgzwlx;

    /***
     * 产权人
     */
    private String cqr;

    /***
     * 结构受力类型
     */
    private String jgsllx;

    /***
     * 占地面积
     */
    private String zdmj;

    /***
     * 设置日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date szrq;

    /***
     * 调查日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date dcrq;

    /***
     * 与隔离栅或防撞护栏的距离(M)
     */
    private String yglshfzhldjl;

    /***
     * 情况说明
     */
    private String qksm;

    /***
     * 上传图片
     */
    private String sctp;

    /***
     * 经度
     */
    private String jd;

    /***
     * 纬度
     */
    private String wd;

    /***
     * 非路产备注
     */
    private String lqbz;

    @Override
    public String getId() {
        return this.lqId;
    }

    @Override
    public void setId(String id) {
        this.lqId = id;
    }
}
