package com.kdgcsoft.jt.xzzf.dubbo.zbgl.road.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className JtjkssVo
 * @author hufanghua
 * @description 交通监控设施实体类
 * @version 1.0
 * @date 2020-04-30 15:23
 */

@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZBGL + "ZBGL_LCLQ_JTJKSS")
public class JtjkssVo extends BaseEntity<String> {

    /***
     *路产Id
     */
    @TableId("LCID")
    private String lcId;

    /******
     * 路产分类id
     */
    private String lcflid;

    /******
     * 路产分类名称
     */
    private String lcflmc;

    /******
     * 名称
     */
    private String mc;

    /******
     * 编码
     */
    private String bm;

    /******
     * 所在路线代码
     */
    private String szlxdm;

    /******
     * 设施所在桩号
     */
    private String ssszzh;

    /******
     * 路政机构
     */
    private String ssdwmc;

    /******
     * 路政机构ID
     */
    private String ssdwid;

     /******
     * 管理单位主键
     */
    private String gldwid;

    /******
     * 管理单位主键
     */
    private String gldwmc;

    /******
     * 类别
     */
    private String lb;

    /******
     * 养护单位
     */
    private String yhdw;

    /******
     * 设置方向
     */
    private String szfx;

    /******
     * 产品名称及型号
     */
    private String cpmcjxh;

    /******
     * 厂家
     */
    private String cj;

    /******
     * 维护电话
     */
    private String whdh;

    /******
     * 设置日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date szrq;

    /******
     * 上传图片
     */
    private String sctp;

    /******
     * 经度
     */
    private String jd;

    /******
     * 纬度
     */
    private String wd;

    /******
     * 路产备注
     */
    private String lcbz;

    @Override
    public String getId() {
        return this.lcId;
    }

    @Override
    public void setId(String id) {
        this.lcId = id;
    }
}
