package com.kdgcsoft.jt.xzzf.dubbo.zbgl.road.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className JsssVo
 * @author Chris
 * @description 架设设施实体类
 * @version 1.0
 * @date 2020-04-30 16:37
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZBGL + "ZBGL_LCLQ_JSSS")
public class JsssVo extends BaseEntity<String> {

    /***
     *路产Id
     */
    @TableId("LCID")
    private String lcId;

    /******
     * 路产分类id
     */
    private String lcflid;

    /******
     * 路产分类名称
     */
    private String lcflmc;

    /******
     * 编码
     */
    private String bm;

    /******
     * 名称
     */
    private String jsssmc;

    /*****
     * 所在路线代码
     */
    private String szlxdm;

    /******
     * 设施所在桩号
     */
    private String ssszzh;

    /*****
     * 路政机构
     */
    private String ssdwmc;

    /******
     * 管理单位主键
     */
    private String gldwid;

    /******
     * 管理单位主键
     */
    private String gldwmc;

    /*****
     * 路政机构ID
     */
    private String ssdwid;

    /*****
     * 涉路方式
     */
    private String slfs;

    /*****
     * 设置方向
     */
    private String szfx;

    /*****
     * 距同侧路缘石距离(M)
     */
    private String jtclysjl;

    /*****
     * 埋设位置
     */
    private String mswz;

    /*****
     * 是否设置交通标志
     */
    private String sfszjtbz;

    /*****
     * 是否设置交通标志文本
     */
    @TableField(exist = false)
    private String sfszjtbzText;

    /*****
     * 是否设置防护设施
     */
    private String sfszfhss;

    /*****
     * 是否批准
     */
    private String sfpz;

    /*****
     * 审批案号
     */
    private String spah;

    /******
     * 审批时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date spsj;

    /******
     * 建设日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date jsrq;

    /******
     * 上传图片
     */
    private String sctp;

    /******
     * 经度
     */
    private String jd;

    /******
     * 纬度
     */
    private String wd;

    /******
     * 路产备注
     */
    private String lcbz;

    /*****
     * 是否设置防护设施Text值
     */
    @TableField(exist = false)
    private String sfszfhssText;

    /*****
     * 是否批准Text值
     */
    @TableField(exist = false)
    private String sfpzText;

    @Override
    public String getId() {
        return this.lcId;
    }

    @Override
    public void setId(String id) {
        this.lcId = id;
    }

}
