package com.kdgcsoft.jt.xzzf.dubbo.zbgl.road.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

/****
 * @className GlbVo
 * @author hufanghua
 * @description 公路碑实体类
 * @version 1.0
 * @date 2020-04-29 15:23
 */

@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZBGL + "ZBGL_LCLQ_GLB")
public class GlbVo extends BaseEntity<String> {

    /***
     *路产Id
     */
    @TableId("LCID")
    private String lcId;

    /******
     * 路产分类id
     */
    private String lcflid;

    /******
     * 路产分类名称
     */
    private String lcflmc;

    /******
     * 所属单位名称
     */
    private String ssdwmc;

    /******
     * 所属单位主键
     */
    private String ssdwid;

    /******
     * 管理单位主键
     */
    private String gldwid;

    /******
     * 管理单位主键
     */
    private String gldwmc;

    /******
     * 公路等级
     */
    private String gldj;

    /******
     * 材质
     */
    private String cz;

    /******
     * 数量
     */
    private String sl;

    /******
     * 上传图片
     */
    private String sctp;

    /******
     * 路产备注
     */
    private String lcbz;

    @Override
    public String getId() {
        return this.lcId;
    }

    @Override
    public void setId(String id) {
        this.lcId = id;
    }
}
