package com.kdgcsoft.jt.xzzf.dubbo.zbgl.road.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className GgpVo
 * @author Chris
 * @description 广告牌实体类
 * @version 1.0
 * @date 2020-04-16 17:22
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZBGL + "ZBGL_LCLQ_GGP")
public class GgpVo extends BaseEntity<String> {

    /*****
     * 路权ID
     */
    @TableId("LQID")
    private String lqId;

    /*****
     * 路权分类
     */
    private String lqflid;

    /*****
     * 路权分类名称
     */
    private String lqflmc;

    /*****
     * 所属单位主键Id
     */
    private String ssdwid;

    /******
     * 管理单位主键
     */
    private String gldwid;

    /******
     * 管理单位主键
     */
    private String gldwmc;

    /******
     * 所属单位名称
     */
    private String ssdwmc;

    /*****
     * 桩号
     */
    private String zh;

    /*****
     * 产权单位
     */
    private String cqdw;

    /*****
     * 是否已经许可
     */
    private String sfyjxk;

    /*****
     * 审核信息
     */
    private String shxx;

    /*****
     * 许可开始时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date xkkssj;

    /*****
     * 许可结束时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date xkjssj;

    /*****
     * 版面形式
     */
    private String bmxs;

    /*****
     * 版面内容
     */
    private String bmnr;

    /*****
     * 广告牌图片路径
     */
    private String ggptplj;

    /*****
     * 经度
     */
    private String jd;

    /*****
     * 纬度
     */
    private String wd;

    /*****
     * 路权备注
     */
    private String lqbz;

    /*****
     * 是否已经许可Text值
     */
    @TableField(exist = false)
    private String sfyjxkText;

    @Override
    public String getId() {
        return this.lqId;
    }

    @Override
    public void setId(String id) {
        this.lqId = id;
    }
}
