package com.kdgcsoft.jt.xzzf.dubbo.zbgl.road.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className CkyssVo
 * @author hufanghua
 * @description 穿跨越设施实体类
 * @version 1.0
 * @date 2020-05-15 15:23
 */

@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZBGL + "ZBGL_LCLQ_CKYSS")
public class CkyssVo extends BaseEntity<String> {

    /***
     *路产Id
     */
    @TableId("LCID")
    private String lcId;

    /******
     * 路产分类id
     */
    private String lcflid;

    /******
     * 路产分类名称
     */
    private String lcflmc;

    /******
     * 名称
     */
    private String mc;

    /******
     * 编码
     */
    private String bm;

    /******
     * 所在路线代码
     */
    private String szlxdm;

    /******
     * 中心设施所在桩号
     */
    private String ssszzh;

    /******
     * 与路中心线交角
     * 距路中心距离
     */
    private String jlzxjl;

    /******
     * 穿跨越方式
     */
    private String ckyfs;

    /******
     * 路政机构
     */
    private String ssdwmc;

    /******
     * 路政机构ID
     */
    private String ssdwid;

    /******
     * 管理单位主键
     */
    private String gldwid;

    /******
     * 管理单位主键
     */
    private String gldwmc;

    /******
     * 最小垂直净空
     */
    private String zxczjk;

    /******
     * 跨越设施框架最小水平间距
     */
    private String kysskjzxspjj;

    /******
     * 是否设置交通标志
     */
    private String sfszjtbz;

    /******
     * 是否设置交通标志文本
     */
    @TableField(exist = false)
    private String sfszjtbzText;

    /******
     * 是否设置防护设施
     */
    private String sfszfhss;

    /******
     * 是否设置防护设施文本
     */
    @TableField(exist = false)
    private String sfszfhssText;

    /******
     * 是否批准
     */
    private String sfpz;

    /******
     * 是否批准文本
     */
    @TableField(exist = false)
    private String sfpzText;

    /******
     * 审批案号
     */
    private String spah;

    /******
     * 建设日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    @ExcelProperty(format = "yyyy-MM-dd")
    private Date jsrq;

    /******
     * 审批时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date spsj;

    /******
     * 上传图片
     */
    private String sctp;

    /******
     * 经度
     */
    private String jd;

    /******
     * 纬度
     */
    private String wd;

    /******
     * 路产备注
     */
    private String lcbz;

    @Override
    public String getId() {
        return this.lcId;
    }

    @Override
    public void setId(String id) {
        this.lcId = id;
    }
}
