package com.kdgcsoft.jt.xzzf.dubbo.zbgl.pub.service;

import com.kdgcsoft.jt.xzzf.common.component.AttachmentVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;

import java.util.List;

/****
 * @className XgfjService
 * @author chris
 * @description 相关附件服务接口层接口
 * @version 1.0
 * @date 2020-04-03 09:08
 */
public interface XgfjService {

    /*******
     * 保存相关附件的信息
     * @param headerType 相关业务表类型
     * @param headerId 相关业务表Id
     * @param details 附件内容
     * @param user 当前用户
     */
    void saveOrUpdate(String headerType, String headerId, String details, SysUser user);

    /******
     * 获取附件列表信息
     * @param headerType 相关业务表类型
     * @param headerId 相关业务表Id
     * @return
     */
    List<AttachmentVo> queryEntityListInfoByHeaderTypeAndHeaderId(String headerType, String headerId);

    /******
     * 删除附件相关信息
     * @param headerType 相关业务表类型
     * @param headerId 相关业务表Id
     * @param ids 附件表主键Id集合
     */
    void logicDeleteEntityInfo(String headerType, String headerId, String ids);

    /******
     * 删除附件相关信息
     * @param headerType 相关业务表类型
     * @param headerId 相关业务表Id
     */
    void deleteEntityInfo(String headerType, String headerId);
}
