package com.kdgcsoft.jt.xzzf.dubbo.zbgl.pub.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.util.Date;

/****
 * @className XgfjVo
 * @author chris
 * @description 相关附件实体类
 * @version 1.0
 * @date 2020-04-02 10:51
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZBGL + "ZBGL_KCZBGL_XGFJ")
public class XgfjVo extends BaseEntity<String> {

    /***
     * 附件ID
     */
    @TableId("FJID")
    private String fjId;

    /***
     * 附件名称
     */
    private String fjmc;

    /***
     * 附件原名称
     */
    private String fjymc;

    /***
     * 文件路径
     */
    private String wjlj;

    /***
     * 文件类型
     */
    private String wjlx;

    /***
     * 上传人
     */
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private String scr;

    /***
     * 上传时间
     */
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private Date scsj;

    /***
     * 业务表名称
     */
    private String ywbmc;

    /***
     * 业务表主键
     */
    private String ywbzj;

    @Override
    public String getId() {
        return this.fjId;
    }

    @Override
    public void setId(String id) {
        this.fjId = id;
    }
}
