package com.kdgcsoft.jt.xzzf.dubbo.zbgl.constants;

import com.kdgcsoft.jt.xzzf.common.constant.DictConstants;

/****
 * @className DictConstant
 * @author chris
 * @description 装备管理数据字典常量配置类
 * @version 1.0
 * @date 2020-03-26 13:37
 */
public class DictConstant extends DictConstants {

    /***
     * 执法车辆信息:ZBGL_CX
     * 01：轻型客车
     * 02：越野车
     * 03：轿车
     * 04:SUV,
     * 05:大型客车,
     * 06:中型客车
     * 07:小型客车,
     * 08:商务车,
     * 09:货车,
     * 99:其他
     */
    public static final String DICT_CODE_ZFCLXX_CX = "ZBGL_CX";
    public static final String DICT_CODE_ZFCLXX_CX_01 = "01";
    public static final String DICT_CODE_ZFCLXX_CX_02 = "02";
    public static final String DICT_CODE_ZFCLXX_CX_03 = "03";
    public static final String DICT_CODE_ZFCLXX_CX_04 = "04";
    public static final String DICT_CODE_ZFCLXX_CX_05 = "05";
    public static final String DICT_CODE_ZFCLXX_CX_06 = "06";
    public static final String DICT_CODE_ZFCLXX_CX_07 = "07";
    public static final String DICT_CODE_ZFCLXX_CX_08 = "08";
    public static final String DICT_CODE_ZFCLXX_CX_09 = "09";
    public static final String DICT_CODE_ZFCLXX_CX_99 = "99";

    /***
     * 执法车辆信息:CLZT
     * 01：使用中
     * 02：大修
     * 03：损坏
     * 04：报废
     */
    public static final String DICT_CODE_ZFCLZTXX_ZFCLZT = "ZBGL_ZFCLZT";
    public static final String DICT_CODE_ZFCZTLXX_ZFCLZT_01 = "01";
    public static final String DICT_CODE_ZFCLZTXX_ZFCLZT_02 = "02";
    public static final String DICT_CODE_ZFCLZTXX_ZFCLZT_03 = "03";
    public static final String DICT_CODE_ZFCLZTXX_ZFCLZT_04 = "04";

    /***
     * 执法装备信息:ZBZT
     * 01：使用中
     * 02：维修
     * 03：损坏
     * 04：报废
     */
    public static final String DICT_CODE_ZFZBZTXX_ZFZBZT = "ZBZT";
    public static final String DICT_CODE_ZFZBZTXX_ZFZBZT_01 = "01";
    public static final String DICT_CODE_ZFZBZTXX_ZFZBZT_02 = "02";
    public static final String DICT_CODE_ZFZBZTXX_ZFZBZT_03 = "03";
    public static final String DICT_CODE_ZFZBZTXX_ZFZBZT_04 = "04";

    /***
     * 执法装备信息:ZJLY
     * 01：上级购置
     * 02：自行采购
     * 03：其他
     */
    public static final String DICT_CODE_ZFZBXX_ZJLY = "ZBGL_ZJLY";
    public static final String DICT_CODE_ZFZBXX_ZJLY_01 = "01";
    public static final String DICT_CODE_ZFZBXX_ZJLY_02 = "02";
    public static final String DICT_CODE_ZFZBXX_ZJLY_03 = "03";

    /***
     * 执法装备信息:JSZK
     * 0：优
     * 1：良
     * 2：差
     */
    public static final String DICT_CODE_ZFZBXX_JSZK = "JSZK";
    public static final String DICT_CODE_ZFZBXX_JSZK_0 = "0";
    public static final String DICT_CODE_ZFZBXX_JSZK_1 = "1";
    public static final String DICT_CODE_ZFZBXX_JSZK_2 = "2";

    /***
     * 示警灯使用证信息:SYZZT
     * 0：到期
     * 1：正常
     * 2：丢失
     * 3:注销
     */
    public static final String DICT_CODE_SYZZTXX_SYZZT = "ZBGL_SYZZT";
    public static final String DICT_CODE_SYZZTXX_SYZZT_0 = "0";
    public static final String DICT_CODE_SYZZTXX_SYZZT_1 = "1";
    public static final String DICT_CODE_SYZZTXX_SYZZT_2 = "2";
    public static final String DICT_CODE_SYZZTXX_SYZZT_3 = "3";

    /*****
     * 路政制服分类:LZZFFL
     * 01:制服
     * 02:装具
     */
    public static final String DICT_CODE_ZFFZ_LZZFFL = "LZZFFL";
    public static final String DICT_CODE_ZFFZ_LZZFFL_01 = "01";
    public static final String DICT_CODE_ZFFZ_LZZFFL_02 = "02";

    /*********
     * 路产分类信息编码
     * ZCZ:治超站
     * QL:桥梁
     * HD:涵洞
     * JTBZ:交通标志
     * SD:隧道
     * SFZ:收费站
     * FWQ:服务区
     * JJTD:紧急通道
     * FSSS:附属设施
     * CKYSS:穿跨越设施
     * JSSS:架设设施
     * JTJKSS:交通监控设施
     * LX:路段
     * GLB:公路碑
     * BMZ:百米桩
     * SJD:示警灯
     * BXLHL:波形梁护栏
     * SJZ:示警桩
     */
    public static final String DICT_CODE_ROAD_LC_ZCZ = "ZCZ";
    public static final String DICT_CODE_ROAD_LC_QL = "QL";
    public static final String DICT_CODE_ROAD_LC_HD = "HD";
    public static final String DICT_CODE_ROAD_LC_JTBZ = "JTBZ";
    public static final String DICT_CODE_ROAD_LC_SD = "SD";
    public static final String DICT_CODE_ROAD_LC_SFZ = "SFZ";
    public static final String DICT_CODE_ROAD_LC_FWQ = "FWQ";
    public static final String DICT_CODE_ROAD_LC_JJTD = "JJTD";
    public static final String DICT_CODE_ROAD_LC_FSSS = "FSSS";
    public static final String DICT_CODE_ROAD_LC_CKYSS = "CKYSS";
    public static final String DICT_CODE_ROAD_LC_JSSS = "JSSS";
    public static final String DICT_CODE_ROAD_LC_JTJKSS = "JTJKSS";
    public static final String DICT_CODE_ROAD_LC_LX = "LX";
    public static final String DICT_CODE_ROAD_LC_GLB = "GLB";
    public static final String DICT_CODE_ROAD_LC_BMZ = "BMZ";
    public static final String DICT_CODE_ROAD_LC_SJD = "SJD";
    public static final String DICT_CODE_ROAD_LC_BXLHL = "BXLHL";
    public static final String DICT_CODE_ROAD_LC_SJZ = "SJZ";

    /*********
     * 非路产分类信息编码
     * GGP:广告牌
     * JZW:建筑控制区建筑物
     */
    public static final String DICT_CODE_ROAD_LQ_GGP = "GGP";
    public static final String DICT_CODE_ROAD_LQ_JZW = "JZKZQJGZW";

    /*******
     * 配发状态:ZBGL_PFZT
     * 01:未配发
     * 02:部分配发
     * 03:全部配发
     * 04:停止配发
     */
    public static final String DICT_CODE_ZBGL_PFZT = "ZBGL_PFZT";
    public static final String DICT_CODE_ZBGL_PFZT_01 = "01";
    public static final String DICT_CODE_ZBGL_PFZT_02 = "02";
    public static final String DICT_CODE_ZBGL_PFZT_03 = "03";
    public static final String DICT_CODE_ZBGL_PFZT_04 = "04";

    /******
     * 配发类型:ZBGL_PFLX
     * 01:首次配发
     * 02:补发
     * 03:到期更换
     */
    public static final String DICT_CODE_ZBGL_PFLX = "ZBGL_PFLX";
    public static final String DICT_CODE_ZBGL_PFLX_01 = "01";
    public static final String DICT_CODE_ZBGL_PFLX_02 = "02";
    public static final String DICT_CODE_ZBGL_PFLX_03 = "03";

    /******
     * 服装发放状态:ZBGL_FZFFZT
     * 01:正常发放
     * 02:停止发放
     */
    public static final String DICT_CODE_ZBGL_FZFFZT = "ZBGL_FZFFZT";
    public static final String DICT_CODE_ZBGL_FZFFZT_01 = "01";
    public static final String DICT_CODE_ZBGL_FZFFZT_02 = "02";

    /*****
     * 状态:ZBGL_STATUS
     * 01:启用
     * 02:禁用
     */
    public static final String DICT_CODE_ZBGL_STATUS = "ZBGL_STATUS";
    public static final String DICT_CODE_ZBGL_STATUS_01 = "01";
    public static final String DICT_CODE_ZBGL_STATUS_02 = "02";

    /*****
     * 主机类型:ZBGL_ZJLX
     * 01:内燃机
     * 02:汽轮机
     * 03:蒸汽机
     * 99:其他
     */
    public static final String DICT_CODE_ZBGL_ZJLX = "ZBGL_ZJLX";
    public static final String DICT_CODE_ZBGL_ZJLX_01 = "01";
    public static final String DICT_CODE_ZBGL_ZJLX_02 = "02";
    public static final String DICT_CODE_ZBGL_ZJLX_03 = "03";
    public static final String DICT_CODE_ZBGL_ZJLX_04 = "04";

    /*****
     * 航区:ZBGL_HQ
     * 03:沿海,06:遮蔽,07:库区,10:内河A,11:内河B,12:内河C,
     * 14:近海,15:远海,16:内河AJ,17:内河BJ,18:内河CJ
     */
    public static final String DICT_CODE_ZBGL_HQ = "ZBGL_HQ";
    public static final String DICT_CODE_ZBGL_HQ_03 = "03";
    public static final String DICT_CODE_ZBGL_HQ_06 = "06";
    public static final String DICT_CODE_ZBGL_HQ_07 = "07";
    public static final String DICT_CODE_ZBGL_HQ_10 = "10";
    public static final String DICT_CODE_ZBGL_HQ_11 = "11";
    public static final String DICT_CODE_ZBGL_HQ_12 = "12";
    public static final String DICT_CODE_ZBGL_HQ_14 = "14";
    public static final String DICT_CODE_ZBGL_HQ_15 = "15";
    public static final String DICT_CODE_ZBGL_HQ_16 = "16";
    public static final String DICT_CODE_ZBGL_HQ_17 = "17";
    public static final String DICT_CODE_ZBGL_HQ_18 = "18";
    /*****
     * 船体材料:ZBGL_CTCL
     *  01:钢质,02木质,03:水泥,04:铝合金,05:玻璃钢,06:橡胶,07:增强纤维,99:其他
     */
    public static final String DICT_CODE_ZBGL_CTCL = "ZBGL_CTCL";
    public static final String DICT_CODE_ZBGL_CTCL_01 = "01";
    public static final String DICT_CODE_ZBGL_CTCL_02 = "02";
    public static final String DICT_CODE_ZBGL_CTCL_03 = "03";
    public static final String DICT_CODE_ZBGL_CTCL_04 = "04";
    public static final String DICT_CODE_ZBGL_CTCL_05 = "05";
    public static final String DICT_CODE_ZBGL_CTCL_06 = "06";
    public static final String DICT_CODE_ZBGL_CTCL_07 = "07";
    public static final String DICT_CODE_ZBGL_CTCL_99 = "99";

    /*****
     * 船籍港代码:ZBGL_CJGDM
     *  2801:合肥,2802:阜阳,2803:亳州,2804:宿州,2805:淮北,2806:蚌阜,
     *  2807:淮南,2808:六安,2809:巢湖,2810:滁州,2811:马鞍山,2812:宣城,
     *  2813:池州,2814:黄山,2815:芜湖,2816:安庆,2817:铜陵
     */
    public static final String DICT_CODE_ZBGL_CJGDM = "ZBGL_CJGDM";
    public static final String DICT_CODE_ZBGL_CJGDM_2801 = "2801";
    public static final String DICT_CODE_ZBGL_CJGDM_2802 = "2802";
    public static final String DICT_CODE_ZBGL_CJGDM_2803 = "2803";
    public static final String DICT_CODE_ZBGL_CJGDM_2804 = "2804";
    public static final String DICT_CODE_ZBGL_CJGDM_2805 = "2805";
    public static final String DICT_CODE_ZBGL_CJGDM_2806 = "2806";
    public static final String DICT_CODE_ZBGL_CJGDM_2807 = "2807";
    public static final String DICT_CODE_ZBGL_CJGDM_2808 = "2808";
    public static final String DICT_CODE_ZBGL_CJGDM_2809 = "2809";
    public static final String DICT_CODE_ZBGL_CJGDM_2810 = "2810";
    public static final String DICT_CODE_ZBGL_CJGDM_2811 = "2811";
    public static final String DICT_CODE_ZBGL_CJGDM_2812 = "2812";
    public static final String DICT_CODE_ZBGL_CJGDM_2813 = "2813";
    public static final String DICT_CODE_ZBGL_CJGDM_2814 = "2814";
    public static final String DICT_CODE_ZBGL_CJGDM_2815 = "2815";
    public static final String DICT_CODE_ZBGL_CJGDM_2816 = "2816";
    public static final String DICT_CODE_ZBGL_CJGDM_2817 = "2817";

    /*****
     * 船舶登记机构:ZBGL_CBDJJG
     * 1211:安庆海事局,
     * 1212:芜湖海事局
     */
    public static final String DICT_CODE_ZBGL_CBDJJG = "ZBGL_CBDJJG";
    public static final String DICT_CODE_ZBGL_CBDJJG_1211 = "1211";
    public static final String DICT_CODE_ZBGL_CBDJJG_1212 = "1212";

    /*****
     * 船舶种类:ZBGL_CBZL
     * 0901:交通艇
     * 0902:引航艇
     * 0905:公务船
     */
    public static final String DICT_CODE_ZBGL_CBZL = "ZBGL_CBZL";
    public static final String DICT_CODE_ZBGL_CBZL_0901 = "0901";
    public static final String DICT_CODE_ZBGL_CBZL_0902 = "0902";
    public static final String DICT_CODE_ZBGL_CBZL_0905 = "0905";

    /*****
     * 库存状态:ZBGL_KCZT
     * 0:在库
     * 1:已配发
     */
    public static final String DICT_CODE_ZBGL_KCZT = "ZBGL_KCZT";
    public static final String DICT_CODE_ZBGL_KCZT_0 = "0";
    public static final String DICT_CODE_ZBGL_KCZT_1 = "1";

    /*****
     * 执法服装预算申报状态:ZBGL_FZSB_STATUS
     * 01-未申报
     * 02:已申报
     */
    public static final String DICT_CODE_ZBGL_FZSB_STATUS = "ZBGL_FZSB_STATUS";
    public static final String DICT_CODE_ZBGL_FZSB_STATUS_01 = "01";
    public static final String DICT_CODE_ZBGL_FZSB_STATUS_02 = "02";

    /*****
     * 执法服装预算申报状态:ZBGL_FZSP_STATUS
     * 00-默认值为空
     * 01-未审批
     * 02:通过
     * 03:不通过
     */
    public static final String DICT_CODE_ZBGL_FZSP_STATUS = "ZBGL_FZSP_STATUS";
    public static final String DICT_CODE_ZBGL_FZSP_STATUS_00 = "00";
    public static final String DICT_CODE_ZBGL_FZSP_STATUS_01 = "01";
    public static final String DICT_CODE_ZBGL_FZSP_STATUS_02 = "02";
    public static final String DICT_CODE_ZBGL_FZSP_STATUS_03 = "03";

    /*****
     * 车辆库存状态:ZBGL_CLKCZT
     * 0:在库
     * 1:已配发
     * 2:已调出
     * 3:已调入
     */
    public static final String DICT_CODE_ZBGL_CLKCZT = "ZBGL_CLKCZT";
    public static final String DICT_CODE_ZBGL_CLKCZT_0 = "0";
    public static final String DICT_CODE_ZBGL_CLKCZT_1 = "1";
    public static final String DICT_CODE_ZBGL_CLKCZT_2 = "2";
    public static final String DICT_CODE_ZBGL_CLKCZT_3 = "3";

    /*****
     * 地貌汉字:ZBGL_DMHZ
     * 1:山岭
     * 2:重丘
     * 3:微丘
     * 4:平原
     */
    public static final String DICT_CODE_ZBGL_DMHZ = "ZBGL_DMHZ";
    public static final String DICT_CODE_ZBGL_DMHZ_1 = "1";
    public static final String DICT_CODE_ZBGL_DMHZ_2 = "2";
    public static final String DICT_CODE_ZBGL_DMHZ_3 = "3";
    public static final String DICT_CODE_ZBGL_DMHZ_4 = "4";

    /*****
     * 面层类型:ZBGL_MCLX
     11:沥青混泥土,12:水泥混泥土 21:沥青贯入式
     22: 沥青碎石 23:沥青表面处冶 31:砂石路面  33:渣石路面 36:无路面
     */
    public static final String DICT_CODE_ZBGL_MCLX = "ZBGL_MCLX";
    public static final String DICT_CODE_ZBGL_MCLX_11 = "11";
    public static final String DICT_CODE_ZBGL_MCLX_21 = "21";
    public static final String DICT_CODE_ZBGL_MCLX_12 = "12";
    public static final String DICT_CODE_ZBGL_MCLX_22 = "22";
    public static final String DICT_CODE_ZBGL_MCLX_23 = "23";
    public static final String DICT_CODE_ZBGL_MCLX_31 = "31";
    public static final String DICT_CODE_ZBGL_MCLX_33 = "33";
    public static final String DICT_CODE_ZBGL_MCLX_36 = "36";

    /*****
     * 服务区构造形式:ZBGL_FWQGZXS
     * 01:单侧
     * 02:双侧
     */
    public static final String DICT_CODE_ZBGL_FWQGZXS = "ZBGL_FWQGZXS";
    public static final String DICT_CODE_ZBGL_FWQGZXS_01 = "01";
    public static final String DICT_CODE_ZBGL_FWQGZXS_02 = "02";

    /*****
     * 治超站类型:ZBGL_ZCZLX
     * 01:单侧
     * 02:双侧
     */
    public static final String DICT_CODE_ZBGL_ZCZLX = "ZBGL_ZCZLX";
    public static final String DICT_CODE_ZBGL_ZCZLX_0 = "0";
    public static final String DICT_CODE_ZBGL_ZCZLX_1 = "1";
    public static final String DICT_CODE_ZBGL_ZCZLX_3 = "3";

    /***
     * 有无高速预检
     * 有：1；
     * 无：0
     */
    public static final String DICT_CODE_HAVE_NO = "YWGSYJ";
    public static final String DICT_CODE_HAVE_NO_1 = "1";
    public static final String DICT_CODE_HAVE_NO_0 = "0";

}
