package com.kdgcsoft.jt.xzzf.dubbo.zbgl.base.service;

import com.kdgcsoft.jt.xzzf.common.component.TreeDataVo;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.base.entity.LqflxxVo;

import java.util.List;

/****
 * @className LqflxxService
 * @author chris
 * @description 非路产分类信息服务接口层接口
 * @version 1.0
 * @date 2020-04-11 15:04
 */
public interface LqflxxService {
    /******
     * 获取非路产分类信息树--指挥调度
     * @param filter 关键字过滤
     * @return
     */
    List<TreeDataVo> queryEntityTreeData(String filter);

    /******
     * 获取非路产分类信息树--装备管理
     * @param filter 关键字过滤
     * @param orgId 机构id
     * @return
     */
    List<TreeDataVo> queryEntityTreeDataZbgl(String filter,String orgId);

    /******
     * 获取非路产分类信息
     * @param code 编码
     * @return
     */
    LqflxxVo getEntityInfoByCode(String code);

    /******
     * 获取非路产分类数量
     * @param orgId 机构id
     * @param flag 是否查询子机构标识
     * @return
     */
    List<LqflxxVo> queryLqflxxCount(String orgId, String flag);
}
