package com.kdgcsoft.jt.xzzf.dubbo.zbgl.base.service;

import com.kdgcsoft.jt.xzzf.common.component.TreeDataVo;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.base.entity.LcflxxVo;

import java.util.List;

/****
 * @className LcflxxService
 * @author chris
 * @description 路产分类信息服务接口层接口
 * @version 1.0
 * @date 2020-04-11 15:03
 */
public interface LcflxxService {
    /******
     * 获取路产分类信息树--指挥调度
     * @param filter 关键字过滤
     * @return
     */
    List<TreeDataVo> queryEntityTreeData(String filter);

    /******
     * 获取路产分类信息树--装备管理
     * @param filter 关键字过滤
     * @param orgId 机构id
     * @return
     */
    List<TreeDataVo> queryEntityTreeDataZbgl(String filter,String orgId);

    /******
     * 获取路产分类信息
     * @param code 编码
     * @return
     */
    LcflxxVo getEntityInfoByCode(String code);

    /******
     * 获取路产分类信息树--装备管理
     * @param orgId 组织机构id
     * @param flag 是否查询子机构标识
     * @return
     */
    List<LcflxxVo> queryLcflxxCount(String orgId, String flag);
}
