package com.kdgcsoft.jt.xzzf.dubbo.zbgl.base.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.ComboboxVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.base.entity.JtbzlxVo;

import java.util.List;

/****
 * @className JtbzlxService
 * @author hufanghua
 * @description 交通标志类型Service接口层接口
 * @version 1.0
 * @date 2020-04-02 15:03
 */
public interface JtbzlxService {
    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @return
     */
    Page<JtbzlxVo> page(Page<JtbzlxVo> page, JtbzlxVo entity);

    /*****
     * 保存或修改交通标志类型数据
     * @param entity 实体类
     * @param user 当前登录用户
     * @param isCreate 是否创建
     */
    void saveOrUpdate(JtbzlxVo entity, SysUser user, boolean isCreate);

    /*****
     * 获取交通标志类型信息
     * @param id 主键ID
     * @return
     */
    JtbzlxVo getEntityInfoById(String id);

    /*****
     * 获取交通标志类型信息
     * @param name 交通标志类型名称
     * @return
     */
    JtbzlxVo getEntityInfoByName(String name);

    /*****
     * 删除交通标志信息
     * @param ids 主键Id集合
     */
    void deleteDataByIds(String ids, SysUser user);

    /*****
     * 交通标志类型下拉框数据
     * @param filter 关键字过滤
     * @return
     */
    List<ComboboxVo> queryEntityCombobox(String filter);

    /*****
     * 获取下一个序号
     * @return
     */
    Integer getNextOrderNo();
}
