package com.kdgcsoft.jt.xzzf.dubbo.zbgl.base.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.ComboboxVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.base.entity.HdlxVo;

import java.util.List;

/****
 * @className HdlxService
 * @author hufanghua
 * @description 涵洞类型Service接口层接口
 * @version 1.0
 * @date 2020-03-28 15:03
 */
public interface HdlxService {
    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @return
     */
    Page<HdlxVo> page(Page<HdlxVo> page, HdlxVo entity);

    /*****
     * 保存或修改涵洞类型数据
     * @param entity 实体类
     * @param user 当前登录用户
     * @param isCreate 是否创建
     */
    void saveOrUpdate(HdlxVo entity, SysUser user, boolean isCreate);

    /*****
     * 获取涵洞类型信息
     * @param id 主键ID
     * @return
     */
    HdlxVo getEntityInfoById(String id);

    /*****
     * 删除涵洞类型信息
     * @param ids 主键Id集合
     */
    void deleteDataByIds(String ids, SysUser user);

    /*****
     * 涵洞类型下拉框数据
     * @param filter 关键字过滤
     * @return
     */
    List<ComboboxVo> queryEntityCombobox(String filter);

    /*****
     * 获取下一个序号
     * @return
     */
    Integer getNextOrderNo();

    /*****
     * 获取涵洞类型信息
     * @param name 涵洞类型名称
     * @return
     */
    HdlxVo getEntityInfoByName(String name);
}
