package com.kdgcsoft.jt.xzzf.dubbo.zbgl.base.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.ComboboxVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.base.entity.FssslxVo;

import java.util.List;

/****
 * @className FssslxService
 * @author hufanghua
 * @description 附属设施类型Service接口层接口
 * @version 1.0
 * @date 2020-03-28 15:03
 */
public interface FssslxService {
    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @return
     */
    Page<FssslxVo> page(Page<FssslxVo> page, FssslxVo entity);

    /*****
     * 保存或修改附属设施类型数据
     * @param entity 实体类
     * @param user 当前登录用户
     * @param isCreate 是否创建
     */
    void saveOrUpdate(FssslxVo entity, SysUser user, boolean isCreate);

    /*****
     * 获取附属设施类型信息
     * @param id 主键ID
     * @return
     */
    FssslxVo getEntityInfoById(String id);

    /*****
     * 获取附属设施类型信息
     * @param name 附属设施类型名称
     * @return
     */
    FssslxVo getEntityInfoByName(String name);

    /*****
     * 删除附属设施类型信息
     * @param ids 主键Id集合
     * @param user 当前登录用户
     */
    void deleteDataByIds(String ids, SysUser user);

    /*****
     * 获取下一个序号
     * @return
     */
    Integer getNextOrderNo();

    /*****
     * 附属设施类型下拉框数据
     * @param filter 关键字过滤
     * @return
     */
    List<ComboboxVo> queryEntityCombobox(String filter);
}
