package com.kdgcsoft.jt.xzzf.dubbo.zbgl.base.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

/****
 * @className LqflxxVo
 * @author chris
 * @description 非路产分类信息实体类
 * @version 1.0
 * @date 2020-04-11 14:57
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZBGL + "ZBGL_LCLQ_LQFLXX")
public class LqflxxVo extends BaseEntity<String> {

    /*****
     * 路权分类ID
     */
    @TableId("LQFLID")
    private String lqflId;

    /*****
     * 路权分类父级ID
     */
    @TableField("LQFLFJID")
    private String lqflfjId;

    /*****
     * 路权分类名称
     */
    @TableField("LQFLMC")
    private String lqflmc;

    /*****
     * 排序
     */
    private String px;

    /*****
     * 说明
     */
    private String sm;

    /*****
     * 备注
     */
    private String bz;

    /*****
     * 路权分类编码
     */
    private String lqflbm;

    /*****
     * 状态
     */
    private String zt;

    /*****
     * 状态Text值
     */
    @TableField(exist = false)
    private String ztText;

    /*****
     * 路权总数
     */
    @TableField(exist = false)
    private String count;

    @Override
    public String getId() {
        return this.lqflId;
    }

    @Override
    public void setId(String id) {
        this.lqflId = id;
    }
}
