package com.kdgcsoft.jt.xzzf.dubbo.zbgl.base.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

/****
 * @className LcflxxVo
 * @author chris
 * @description 路产分类信息实体类
 * @version 1.0
 * @date 2020-04-11 14:57
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZBGL + "ZBGL_LCLQ_LCFLXX")
public class LcflxxVo extends BaseEntity<String> {

    /*****
     * 路产分类ID
     */
    @TableId("LCFLID")
    private String lcflId;

    /*****
     * 路产分类父级ID
     */
    private String lcflfjId;

    /*****
     * 路产分类名称
     */
    private String lcflmc;

    /*****
     * 排序
     */
    private String px;

    /*****
     * 说明
     */
    private String sm;

    /*****
     * 备注
     */
    private String bz;

    /*****
     * 路产分类编码
     */
    private String lcflbm;

    /*****
     * 状态
     */
    private String zt;

    /*****
     * 状态Text值
     */
    @TableField(exist = false)
    private String ztText;

    /*****
     * 路产总数
     */
    @TableField(exist = false)
    private String count;


    @Override
    public String getId() {
        return this.lcflId;
    }

    @Override
    public void setId(String id) {
        this.lcflId = id;
    }
}
