package com.kdgcsoft.jt.xzzf.dubbo.zbgl.base.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

/****
 * @className HdlxVo
 * @author hufanghua
 * @description 涵洞类型信息实体
 * @version 1.0
 * @date 2020-04-03 09:59
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZBGL + "ZBGL_LCLQ_HDLX")
public class HdlxVo extends BaseEntity<String> {

    /***
     * 涵洞类型Id
     */
    @TableId("HDLXID")
    private String hdlxid;

    /******
     * 涵洞类型编码
     */
    private String hdlxbm;

    /******
     * 涵洞类型名称
     */
    private String hdlxmc;

    /******
     * 涵洞类型状态
     */
    private String zt;

    /******
     * 涵洞类型排序
     */
    private String px;

    /******
     * 涵洞类型备注
     */
    private String bz;

    /******
     * 涵洞类型状态Text
     */
    @TableField(exist = false)
    private String ztText;

    @Override
    public String getId() {
        return this.hdlxid;
    }

    @Override
    public void setId(String id) {
        this.hdlxid = id;
    }
}
