package com.kdgcsoft.jt.xzzf.dubbo.zbgl.api.service;

import com.kdgcsoft.jt.xzzf.dubbo.zbgl.api.entity.RoadLcVo;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.api.entity.RoadLqVo;

import java.util.List;

/****
 * @className RoadService
 * @author chris
 * @description 路产非路产公共服务层接口
 * @version 1.0
 * @date 2020-06-16 20:44
 */
public interface RoadService {

    /******
     * 获取路产信息
     * @param entity 实体类
     * @param filter 关键字
     * @param orgId 组织机构Id
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    public List<RoadLcVo> RoadLcDataList(RoadLcVo entity, String filter, String orgId, String curUserOrgId);

    /******
     * 获取非路产信息
     * @param entity 实体类
     * @param filter 关键字
     * @param orgId 组织机构Id
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    public List<RoadLqVo> RoadLqDataList(RoadLqVo entity, String filter, String orgId, String curUserOrgId);

}
