package com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.service;

import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.Requestparam;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.XzspJLocksqVO;

import java.util.List;

/**
 * <p>
 * 行政审批-申请信息锁表信息表 服务类
 * </p>
 *
 * @author 刘梦寻
 * @since 2020-05-20
 */
public interface XzspJLocksqService {

    /**
     * 申请信息-添加锁定
     *
     * @param xzspJLocksq 锁表信息
     * @return
     */
    boolean addLock(XzspJLocksqVO xzspJLocksq);

    /**
     * 申请信息-解除锁定
     *
     * @param sqxxId　申请信息ID
     * @return
     */
    boolean deleteLockById(String sqxxId);

    /**
     * 申请信息-获取锁定信息
     *
     * @param sqxxId 申请信息ID
     * @return
     */
    XzspJLocksqVO getLockById(String sqxxId);

    /**
     * 检查申请列表是否锁定，没锁定则加锁
     * @param sqxxIds 申请信息ID数组
     * @return
     */
    List<String> checkLocksStatus(List<String> sqxxIds, SysUser curUser);

    /**
     * 申请列表解除锁定
     * @param sqxxIds 申请信息ID数组
     * @return
     */
    boolean removeLocksStatus(List<String> sqxxIds);
}

