package com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.*;

import java.util.List;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author flm
 * @since 2020-05-11
 */
public interface XzspJBjyjxxService {

    /**
     * 新增信息
     *
     * @param xzspJBjyjxx
     * @return
     */
    boolean insert(BjyjxxVO xzspJBjyjxx);

    /**
     * 修改信息
     *
     * @param xzspJBjyjxx
     * @return
     */
    boolean updateById(BjyjxxVO xzspJBjyjxx);

    /**
     * 根据ID删除信息
     *
     * @param id　ID
     * @return
     */
    boolean deleteById(String id);

    /**
     * 根据ID获取信息
     *
     * @param id
     * @return
     */
    BjyjxxVO getById(String id);


    /**
     * 分页查询预警
     *
     * @param current 当前页
     * @param size 每页显示条数
     * @param bjyjxxVO
     * @return
     */
    Page<BjyjxxVO> page(long current, long size, BjyjxxVO bjyjxxVO);

    /**
     * 获得审批机构代码
     * @param spjgdm
     * @return
     */
    String getOrgCodeByOrgId(String spjgdm);

    /**
     * 根据查询参数获取申请信息-办件查询页面-分页
     *
     * @param current 当前页
     * @param size 每页显示条数
     * @param sqxxVo 查询参数
     * @return
     */
    Page<SqxxVo> chaXunPage(long current, long size, SqxxVo sqxxVo);

    /**
     * 根据查询参数获取申请信息-办件查询页面-所有
     *
     * @param sqxxVo 查询参数
     * @return
     */
    List<SqxxVo> chaXunPage(SqxxVo sqxxVo);

    /**
     * 根据申请信息ID数组获取申请信息-办件查询页面
     *
     * @param sqxxIds 申请信息ID数组
     * @return
     */
    List<SqxxVo> chaXunBySqxxIds(String[] sqxxIds);

    /**
     * 分页查询-查询流程记录
     *
     * @param current 当前页
     * @param size 每页显示条数
     * @param sqxxid
     * @return
     */
    Page<XzspJSpjlVO> jlChaXunPage(long current, long size, String sqxxid);

    /**
     * 查询流程记录
     *
     * @param sqxxid
     * @return
     */
    List<XzspJSpjlVO> JlList(String sqxxid);

    /**
     * 联合审批
     * @param page
     * @param rows
     * @param sqxxid
     * @return
     */
	Page<XzspJKsdqspztVO> lhspPage(long page, long rows, String sqxxid);

}

