package com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.DocTreeNode;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.XzspDZxyjhVO;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.XzspDZxyjhhVO;
import net.sf.json.JSONArray;

import java.util.List;

/**
 * <p>
 * 超限征询函服务类
 * </p>
 *
 * @author 周杰
 * @since 2020-05-22
 */
public interface XzspDZxyjhService {
    /**
     * 发函 分页查询，可查询全部，也可按条件查询
     *
     * @param current      当前页
     * @param size         每页显示条数
     * @param xzspDZxyjhVO 查询条件
     * @return 查询结果
     */
    IPage<XzspDZxyjhVO> page(long current, long size, XzspDZxyjhVO xzspDZxyjhVO);

    /**
     * 根据ID删除函文
     *
     * @param xzspDZxyjhVO 删除条件
     * @return 删除结果
     */
    boolean deleteById(XzspDZxyjhVO xzspDZxyjhVO);

    /**
     * 查询可发函案件
     *
     * @param current      当前页
     * @param size         每页显示条数
     * @param xzspDZxyjhVO 条件
     * @return 结果
     */
    IPage<XzspDZxyjhVO> queryInfoByAny(long current, long size, XzspDZxyjhVO xzspDZxyjhVO);

    /**
     * 生成文书
     *
     * @param xzspDZxyjhVO 生成文书所要的属性
     * @return 生成结果
     */
    boolean saveCxzxh(XzspDZxyjhVO xzspDZxyjhVO, String sqcxxx, SysUser curUser);

    /**
     * 分页查询，可查询全部，也可按条件查询,回函页面
     *
     * @param current      当前页
     * @param size         每页显示条数
     * @param xzspDZxyjhVO 查询条件
     * @return 查询结果
     */
    IPage<XzspDZxyjhVO> pageHh(long current, long size, XzspDZxyjhVO xzspDZxyjhVO);

    /**
     * 加载树
     *
     * @return 加载树list
     */
    List<DocTreeNode> getTree();

    /**
     * 更新回函状态
     *
     * @param xzspDZxyjhVO 更新条件
     * @return list
     */
    boolean updateCxzxhHhzt(XzspDZxyjhVO xzspDZxyjhVO);

    /**
     * 查询超限回函valueid
     *
     * @param xzspDZxyjhVO 查询条件
     * @return 查询结果
     */
    XzspDZxyjhhVO slelectCxzxhhValueId(XzspDZxyjhVO xzspDZxyjhVO);

    /**
     * 查询当前案件是否有回函
     *
     * @return 回函文书valueId
     */
    boolean isValueId(XzspDZxyjhVO xzspDZxyjhVO);

    /**
     * 更新通行情况
     *
     * @param xzspDZxyjhhVO 更新条件
     * @return 更新结果
     */
    boolean updateTxqk(XzspDZxyjhhVO xzspDZxyjhhVO);

    /**
     * 查询超限发函最新联系人
     *
     * @param xzspDZxyjhVO 查询条件
     * @return 查询结果
     */
    XzspDZxyjhVO slelectCxzxhLxr(XzspDZxyjhVO xzspDZxyjhVO);

    /**
     * 查询超限发函回函状态
     *
     * @param xzspDZxyjhVO 查询条件
     * @return 查询结果
     */
    XzspDZxyjhVO slelectCxzxhHhzt(XzspDZxyjhVO xzspDZxyjhVO);

    /**
     * 查询函文是否已发
     *
     * @param xzspDZxyjhVO 查询条件
     * @return 查询结果
     */
    List<XzspDZxyjhVO> querySffh(XzspDZxyjhVO xzspDZxyjhVO, JSONArray array);

    /**
     * App生成回函文书
     *
     * @param xzspDZxyjhhVO 生成文书所要的属性
     * @return 生成结果
     */
    boolean saveCxzxhh(XzspDZxyjhhVO xzspDZxyjhhVO, SysUser curUser);

    /**
     * 转发函文
     *
     * @param xzspDZxyjhVOId 生成函文信息
     * @param jsdwArrStr     接受单位数组json
     * @param jsdwbmArrStr   接受单位编码json
     * @return 生成结果
     */
    boolean transferOther(String xzspDZxyjhVOId, String jsdwArrStr, String jsdwbmArrStr, SysUser curUser);

}


