package com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.DocTreeNode;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.XzspDYgzxhVO;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.xkbl.entity.XzspDYgzxhhVO;
import java.util.List;

/**
 * <p>
 * 运管征询函 服务类
 * </p>
 *
 * @author 周杰
 * @since 2020-06-02
 */
public interface XzspDYgzxhService {
    /**
     * 发函分页查询，可查询全部，也可按条件查询
     *
     * @param page 当前页
     * @param rows 每页显示条数
     * @param xzspDZxyjhVO 查询条件
     * @return 查询结果
     */
    IPage<XzspDYgzxhVO> fhPage(long page, long rows, XzspDYgzxhVO xzspDZxyjhVO);

    /**
     * 根据ID删除函文
     * @param xzspDYgzxhVO 删除条件
     * @return 删除结果
     */
    boolean deleteById(XzspDYgzxhVO xzspDYgzxhVO);

    /**
     * 查询可发函案件
     * @param page 当前页
     * @param rows 每页显示条数
     * @param xzspDYgzxhVO 条件
     * @return 结果
     */
    IPage<XzspDYgzxhVO> queryYgzxhAj(long page, long rows,XzspDYgzxhVO xzspDYgzxhVO);

    /**
     * 生成文书
     * @param xzspDYgzxhVO 生成文书所要的属性
     * @return 生成结果
     */
    boolean saveYgzxh(XzspDYgzxhVO xzspDYgzxhVO, SysUser curUser);

    /**
     * 回函分页查询，可查询全部，也可按条件查询
     * @param page 当前页
     * @param rows 每页显示条数
     * @param xzspDZxyjhVO 查询条件
     * @return 查询结果
     */
    IPage<XzspDYgzxhVO> hhPage(long page, long rows, XzspDYgzxhVO xzspDZxyjhVO);

    /**
     * 加载树
     * @return list
     */
    List<DocTreeNode> getTree();

    /**
     * 更新回函状态
     * @param xzspDYgzxhVO 更新条件
     * @return list
     */
    boolean updataYgzxhHhzt(XzspDYgzxhVO xzspDYgzxhVO);

    /**
     * 检查是否已经运管回函
     * @param orgName 接收单位
     * @param eventid 申请信息id
     * @return 已回函和无对应发函返回 true, 未回函返回 false
     */
    boolean checkYgzxhh(String orgName, String eventid);

    /**
     * 获取回函文书
     * @param orgName 接收单位
     * @param eventid 申请信息id
     * @return
     */
    XzspDYgzxhhVO selectYgzxhh(String orgName, String eventid);

    /**
     * 查询最新运管发函联系人
     * @param xzspDYgzxhVO 查询条件
     * @return 查询结果
     */
    XzspDYgzxhVO slelectYgzxhLxr(XzspDYgzxhVO xzspDYgzxhVO);

    /**
     * 查询运管发函回函状态
     * @param xzspDZxyjhVO 查询条件
     * @return 查询结果
     */
    XzspDYgzxhVO slelectCxzxhHhzt(XzspDYgzxhVO xzspDZxyjhVO);

    /**
     * 查询函文是否已发
     * @param xzspDYgzxhVO 查询条件
     * @return 查询结果
     */
    List<XzspDYgzxhVO> querySffh(XzspDYgzxhVO xzspDYgzxhVO);

    /**
     * App生成运管回函文书
     * @param xzspDYgzxhhVO 生成文书所要的属性
     * @return 生成结果
     */
    boolean saveYgzxhh(XzspDYgzxhhVO xzspDYgzxhhVO, SysUser curUser);
}

